/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.google.common.base.Ticker;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.management.config.GraphiteClientProperties;
import pl.allegro.tech.hermes.management.config.MetricsProperties;
import pl.allegro.tech.hermes.management.infrastructure.graphite.CachingGraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.RestTemplateGraphiteClient;
import pl.allegro.tech.hermes.management.stub.MetricsPaths;

@Configuration
@EnableConfigurationProperties(value={MetricsProperties.class, GraphiteClientProperties.class})
public class GraphiteClientConfiguration {
    @Autowired
    MetricsProperties metricsProperties;
    @Autowired
    GraphiteClientProperties graphiteClientProperties;

    @Bean
    public MetricsPaths metricsPaths() {
        return new MetricsPaths(this.metricsProperties.getPrefix());
    }

    @Bean
    public GraphiteClient graphiteClient(@Qualifier(value="graphiteRestTemplate") RestTemplate graphiteRestTemplate) {
        RestTemplateGraphiteClient underlyingGraphiteClient = new RestTemplateGraphiteClient(graphiteRestTemplate, URI.create(this.metricsProperties.getGraphiteHttpUri()));
        return new CachingGraphiteClient(underlyingGraphiteClient, Ticker.systemTicker(), this.graphiteClientProperties.getCacheTtlSeconds(), this.graphiteClientProperties.getCacheSize());
    }

    @Bean(value={"graphiteRestTemplate"})
    public RestTemplate restTemplate(GraphiteClientProperties properties) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(properties.getConnectionTimeoutMillis()).setSocketTimeout(properties.getSocketTimeoutMillis()).build();
        CloseableHttpClient client = HttpClientBuilder.create().setMaxConnTotal(properties.getMaxConnections()).setMaxConnPerRoute(properties.getMaxConnectionsPerRoute()).setDefaultRequestConfig(requestConfig).build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

