/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.blacklist.commands;

import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class RemoveTopicFromBlacklistRepositoryCommand
extends RepositoryCommand<TopicBlacklistRepository> {
    private final String qualifiedTopicName;
    private boolean exists = false;

    public RemoveTopicFromBlacklistRepositoryCommand(String qualifiedTopicName) {
        this.qualifiedTopicName = qualifiedTopicName;
    }

    @Override
    public void backup(DatacenterBoundRepositoryHolder<TopicBlacklistRepository> holder) {
        this.exists = holder.getRepository().isBlacklisted(this.qualifiedTopicName);
    }

    @Override
    public void execute(DatacenterBoundRepositoryHolder<TopicBlacklistRepository> holder) {
        holder.getRepository().remove(this.qualifiedTopicName);
    }

    @Override
    public void rollback(DatacenterBoundRepositoryHolder<TopicBlacklistRepository> holder) {
        if (this.exists) {
            holder.getRepository().add(this.qualifiedTopicName);
        }
    }

    @Override
    public Class<TopicBlacklistRepository> getRepositoryType() {
        return TopicBlacklistRepository.class;
    }

    public String toString() {
        return "RemoveTopicFromBlacklist(" + this.qualifiedTopicName + ")";
    }
}

