/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ErrorCode;
import pl.allegro.tech.hermes.common.exception.HermesException;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSourceNotFound;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;
import pl.allegro.tech.hermes.management.migration.owner.SupportTeamToOwnerMigrator;

@Component
@Path(value="/migrations")
@RolesAllowed(value={"admin"})
@Api(value="/migrations", description="Storage schema & data migrations")
public class MigrationsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(MigrationsEndpoint.class);
    private static final String SUPPORT_TEAM_TO_OWNER_MIGRATION_NAME = "support-team-to-owner";
    private final SupportTeamToOwnerMigrator supportTeamToOwnerMigrator;
    private final OwnerSources ownerSources;

    @Autowired
    public MigrationsEndpoint(SupportTeamToOwnerMigrator supportTeamToOwnerMigrator, OwnerSources ownerSources) {
        this.supportTeamToOwnerMigrator = supportTeamToOwnerMigrator;
        this.ownerSources = ownerSources;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List possible migrations", response=List.class, httpMethod="GET")
    public List<String> list() {
        return ImmutableList.of((Object)SUPPORT_TEAM_TO_OWNER_MIGRATION_NAME);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{name}")
    @ApiOperation(value="Execute migration", httpMethod="POST")
    public SupportTeamToOwnerMigrator.ExecutionStats execute(@PathParam(value="name") String name, @QueryParam(value="source") String sourceName, @DefaultValue(value="false") @QueryParam(value="override") boolean overrideOwners, @Context SecurityContext securityContext) {
        if (SUPPORT_TEAM_TO_OWNER_MIGRATION_NAME.equals(name)) {
            this.ownerSources.getByName(sourceName).orElseThrow(() -> new OwnerSourceNotFound(sourceName));
            logger.info("{} migration triggered by user {}", (Object)SUPPORT_TEAM_TO_OWNER_MIGRATION_NAME, (Object)securityContext.getUserPrincipal().getName());
            return this.supportTeamToOwnerMigrator.execute(sourceName, overrideOwners ? SupportTeamToOwnerMigrator.OwnerExistsStrategy.OVERRIDE : SupportTeamToOwnerMigrator.OwnerExistsStrategy.SKIP);
        }
        throw new UnknownMigrationException(name);
    }

    private static class UnknownMigrationException
    extends HermesException {
        UnknownMigrationException(String migrationName) {
            super("Unknown migration '" + migrationName + "'");
        }

        public ErrorCode getCode() {
            return ErrorCode.UNKNOWN_MIGRATION;
        }
    }
}

