/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.MessageTextPreview;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.api.TopicWithSchema;
import pl.allegro.tech.hermes.common.exception.BrokerNotFoundForPartitionException;
import pl.allegro.tech.hermes.management.api.auth.ManagementRights;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSource;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSourceNotFound;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;
import pl.allegro.tech.hermes.management.domain.topic.CreatorRights;
import pl.allegro.tech.hermes.management.domain.topic.SingleMessageReaderException;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;

@Component
@Path(value="/topics")
@Api(value="/topics", description="Operations on topics")
public class TopicsEndpoint {
    private final TopicService topicService;
    private final ManagementRights managementRights;
    private final OwnerSources ownerSources;

    @Autowired
    public TopicsEndpoint(TopicService topicService, ManagementRights managementRights, OwnerSources ownerSources) {
        this.topicService = topicService;
        this.managementRights = managementRights;
        this.ownerSources = ownerSources;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List topics from group", response=List.class, httpMethod="GET")
    public List<String> list(@DefaultValue(value="") @QueryParam(value="groupName") String groupName, @DefaultValue(value="false") @QueryParam(value="tracked") boolean tracked) {
        return tracked ? this.listTracked(groupName) : this.listNames(groupName);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/query")
    @ApiOperation(value="Queries topics from group", response=List.class, httpMethod="POST")
    public List<String> queryList(@DefaultValue(value="") @QueryParam(value="groupName") String groupName, Query<Topic> query) {
        return Strings.isNullOrEmpty((String)groupName) ? this.topicService.listFilteredTopicNames(query) : this.topicService.listFilteredTopicNames(groupName, query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"any"})
    @ApiOperation(value="Create topic", httpMethod="POST")
    public Response create(TopicWithSchema topicWithSchema, @Context ContainerRequestContext requestContext) {
        RequestUser requestUser = RequestUser.fromSecurityContext(requestContext.getSecurityContext());
        CreatorRights isAllowedToManage = checkedTopic -> this.managementRights.isUserAllowedToManageTopic(checkedTopic, requestContext);
        this.topicService.createTopicWithSchema(topicWithSchema, requestUser, isAllowedToManage);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{topicName}")
    @RolesAllowed(value={"admin", "topicOwner"})
    @ApiOperation(value="Remove topic", httpMethod="DELETE")
    public Response remove(@PathParam(value="topicName") String qualifiedTopicName, @Context SecurityContext securityContext) {
        RequestUser requestUser = RequestUser.fromSecurityContext(securityContext);
        this.topicService.removeTopicWithSchema(this.topicService.getTopicDetails(TopicName.fromQualifiedName((String)qualifiedTopicName)), requestUser);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{topicName}")
    @RolesAllowed(value={"admin", "topicOwner"})
    @ApiOperation(value="Update topic", httpMethod="PUT")
    public Response update(@PathParam(value="topicName") String qualifiedTopicName, PatchData patch, @Context SecurityContext securityContext) {
        RequestUser requestUser = RequestUser.fromSecurityContext(securityContext);
        this.topicService.updateTopicWithSchema(TopicName.fromQualifiedName((String)qualifiedTopicName), patch, requestUser);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{topicName}")
    @ApiOperation(value="Topic details", httpMethod="GET")
    public TopicWithSchema get(@PathParam(value="topicName") String qualifiedTopicName) {
        return this.topicService.getTopicWithSchema(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{topicName}/metrics")
    @ApiOperation(value="Topic metrics", httpMethod="GET")
    public TopicMetrics getMetrics(@PathParam(value="topicName") String qualifiedTopicName) {
        return this.topicService.getTopicMetrics(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{topicName}/preview")
    @ApiOperation(value="Topic publisher preview", httpMethod="GET")
    public List<MessageTextPreview> getPreview(@PathParam(value="topicName") String qualifiedTopicName) {
        return this.topicService.previewText(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/{topicName}/preview/{idx}")
    @ApiOperation(value="Topic publisher preview", httpMethod="GET")
    public byte[] getPreviewRaw(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="idx") Integer idx) {
        TopicName topicName = TopicName.fromQualifiedName((String)qualifiedTopicName);
        Optional<byte[]> preview = this.topicService.preview(topicName, idx);
        if (preview.isPresent()) {
            return preview.get();
        }
        throw new NotFoundException(String.format("Message preview not found for topic %s and offset %d", topicName, idx));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{topicName}/preview/cluster/{brokersClusterName}/partition/{partition}/offset/{offset}")
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Fetch single message from specified brokers cluster", httpMethod="GET")
    public String preview(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="brokersClusterName") String brokersClusterName, @PathParam(value="partition") Integer partition, @PathParam(value="offset") Long offset) {
        try {
            return this.topicService.fetchSingleMessageFromPrimary(brokersClusterName, TopicName.fromQualifiedName((String)qualifiedTopicName), partition, offset);
        }
        catch (BrokerNotFoundForPartitionException | SingleMessageReaderException exception) {
            throw new NotFoundException(String.format("Message not found for brokers cluster %s, topic %s, partition %d and offset %d", brokersClusterName, qualifiedTopicName, partition, offset));
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/owner/{ownerSourceName}/{ownerId}")
    public List<Topic> listForOwner(@PathParam(value="ownerSourceName") String ownerSourceName, @PathParam(value="ownerId") String id) {
        OwnerSource ownerSource = this.ownerSources.getByName(ownerSourceName).orElseThrow(() -> new OwnerSourceNotFound(ownerSourceName));
        if (!ownerSource.exists(id)) {
            throw new OwnerSource.OwnerNotFound(ownerSourceName, id);
        }
        OwnerId ownerId = new OwnerId(ownerSource.name(), id);
        return this.topicService.listForOwnerId(ownerId);
    }

    private List<String> listTracked(String groupName) {
        return Strings.isNullOrEmpty((String)groupName) ? this.topicService.listTrackedTopicNames() : this.topicService.listTrackedTopicNames(groupName);
    }

    private List<String> listNames(String groupName) {
        return Strings.isNullOrEmpty((String)groupName) ? this.topicService.listQualifiedTopicNames() : this.topicService.listQualifiedTopicNames(groupName);
    }
}

