/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.auth;

import java.util.Objects;
import javax.ws.rs.core.SecurityContext;

public class RequestUser {
    private final String username;
    private final boolean isAdmin;

    public RequestUser(String username, boolean isAdmin) {
        this.username = username;
        this.isAdmin = isAdmin;
    }

    public static RequestUser fromSecurityContext(SecurityContext securityContext) {
        String username = securityContext.getUserPrincipal().getName();
        boolean isAdmin = securityContext.isUserInRole("admin");
        return new RequestUser(username, isAdmin);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestUser requestUser = (RequestUser)o;
        return this.isAdmin == requestUser.isAdmin && Objects.equals(this.username, requestUser.username);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.isAdmin);
    }
}

