/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.consistency;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MetadataCopies {
    private final String id;
    private final Map<String, Object> copyPerDatacenter = new HashMap<String, Object>();

    MetadataCopies(String id, Set<String> datacenters) {
        this.id = id;
        datacenters.forEach(dc -> this.copyPerDatacenter.put((String)dc, null));
    }

    void put(String datacenter, Object value) {
        if (!this.copyPerDatacenter.containsKey(datacenter)) {
            throw new IllegalArgumentException("Invalid datacenter: " + datacenter);
        }
        this.copyPerDatacenter.put(datacenter, value);
    }

    boolean areAllEqual() {
        return this.copyPerDatacenter.values().stream().distinct().count() == 1L;
    }

    String getId() {
        return this.id;
    }

    Map<String, Object> getCopyPerDatacenter() {
        return this.copyPerDatacenter;
    }
}

