/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.dc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.management.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.management.infrastructure.dc.DcNameProvisionException;

public class EnvironmentVariableDatacenterNameProvider
implements DatacenterNameProvider {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentVariableDatacenterNameProvider.class);
    private String variableName;

    public EnvironmentVariableDatacenterNameProvider(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public String getDatacenterName() {
        String dcName = System.getenv(this.variableName);
        if (dcName == null) {
            throw new DcNameProvisionException("Undefined environment variable: " + this.variableName);
        }
        logger.info("Providing DC name from environment variable: {}={}", (Object)this.variableName, (Object)dcName);
        return dcName;
    }
}

