/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.SubscriptionConstraints;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicConstraints;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.workload.constraints.ConsumersWorkloadConstraints;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;
import pl.allegro.tech.hermes.management.domain.workload.constraints.WorkloadConstraintsService;

@Component
@Path(value="/workload-constraints")
@Api(value="/workload-constraints", description="Operations on workload constraints")
public class WorkloadConstraintsEndpoint {
    private final WorkloadConstraintsService service;

    public WorkloadConstraintsEndpoint(WorkloadConstraintsService service) {
        this.service = service;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"any"})
    @ApiOperation(value="All workload constraints", response=List.class, httpMethod="GET")
    public ConsumersWorkloadConstraints getConsumersWorkloadConstraints() {
        return this.service.getConsumersWorkloadConstraints();
    }

    @PUT
    @Path(value="/topic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Create or update topic constraints", response=String.class, httpMethod="PUT")
    public Response createOrUpdateTopicConstraints(@Valid TopicConstraints topicConstraints, @Context SecurityContext securityContext) {
        RequestUser requestUser = RequestUser.fromSecurityContext(securityContext);
        if (this.service.constraintsExist(topicConstraints.getTopicName())) {
            this.service.updateConstraints(topicConstraints.getTopicName(), topicConstraints.getConstraints(), requestUser);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        this.service.createConstraints(topicConstraints.getTopicName(), topicConstraints.getConstraints(), requestUser);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/topic/{topicName}")
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Remove topic constraints", response=String.class, httpMethod="DELETE")
    public Response deleteTopicConstraints(@PathParam(value="topicName") String topicName, @Context SecurityContext securityContext) {
        this.service.deleteConstraints(TopicName.fromQualifiedName((String)topicName), RequestUser.fromSecurityContext(securityContext));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="/subscription")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Create or update subscription constraints", response=String.class, httpMethod="PUT")
    public Response createOrUpdateSubscriptionConstraints(@Valid SubscriptionConstraints subscriptionConstraints, @Context SecurityContext securityContext) {
        RequestUser requestUser = RequestUser.fromSecurityContext(securityContext);
        if (this.service.constraintsExist(subscriptionConstraints.getSubscriptionName())) {
            this.service.updateConstraints(subscriptionConstraints.getSubscriptionName(), subscriptionConstraints.getConstraints(), requestUser);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        this.service.createConstraints(subscriptionConstraints.getSubscriptionName(), subscriptionConstraints.getConstraints(), requestUser);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/subscription/{topicName}/{subscriptionName}")
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Remove subscription constraints", response=String.class, httpMethod="DELETE")
    public Response deleteSubscriptionConstraints(@PathParam(value="topicName") String topicName, @PathParam(value="subscriptionName") String subscriptionName, @Context SecurityContext securityContext) {
        this.service.deleteConstraints(new SubscriptionName(subscriptionName, TopicName.fromQualifiedName((String)topicName)), RequestUser.fromSecurityContext(securityContext));
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

