/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.management.domain.topic.TopicMetricsRepository;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteMetrics;
import pl.allegro.tech.hermes.management.infrastructure.metrics.SummedSharedCounter;
import pl.allegro.tech.hermes.management.stub.MetricsPaths;

@Component
public class HybridTopicMetricsRepository
implements TopicMetricsRepository {
    private static final String RATE_PATTERN = "sumSeries(%s.producer.*.meter.%s.%s.m1_rate)";
    private static final String DELIVERY_RATE_PATTERN = "sumSeries(%s.consumer.*.meter.%s.%s.m1_rate)";
    private static final String THROUGHPUT_PATTERN = "sumSeries(%s.producer.*.throughput.%s.%s.m1_rate)";
    private final GraphiteClient graphiteClient;
    private final MetricsPaths metricsPaths;
    private final SummedSharedCounter summedSharedCounter;
    private final ZookeeperPaths zookeeperPaths;
    private final SubscriptionRepository subscriptionRepository;

    public HybridTopicMetricsRepository(GraphiteClient graphiteClient, MetricsPaths metricsPaths, SummedSharedCounter summedSharedCounter, ZookeeperPaths zookeeperPaths, SubscriptionRepository subscriptionRepository) {
        this.graphiteClient = graphiteClient;
        this.metricsPaths = metricsPaths;
        this.summedSharedCounter = summedSharedCounter;
        this.zookeeperPaths = zookeeperPaths;
        this.subscriptionRepository = subscriptionRepository;
    }

    @Override
    public TopicMetrics loadMetrics(TopicName topicName) {
        String rateMetric = this.metricPath(RATE_PATTERN, topicName);
        String deliveryRateMetric = this.metricPath(DELIVERY_RATE_PATTERN, topicName);
        String throughputMetric = this.metricPath(THROUGHPUT_PATTERN, topicName);
        GraphiteMetrics metrics = this.graphiteClient.readMetrics(rateMetric, deliveryRateMetric);
        return TopicMetrics.Builder.topicMetrics().withRate(metrics.metricValue(rateMetric)).withDeliveryRate(metrics.metricValue(deliveryRateMetric)).withPublished(this.summedSharedCounter.getValue(this.zookeeperPaths.topicMetricPath(topicName, "published"))).withVolume(this.summedSharedCounter.getValue(this.zookeeperPaths.topicMetricPath(topicName, "volume"))).withSubscriptions(this.subscriptionRepository.listSubscriptionNames(topicName).size()).withThroughput(metrics.metricValue(throughputMetric)).build();
    }

    private String metricPath(String pattern, TopicName topicName) {
        return String.format(pattern, this.metricsPaths.prefix(), HermesMetrics.escapeDots((String)topicName.getGroupName()), HermesMetrics.escapeDots((String)topicName.getName()));
    }
}

