/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.InconsistentGroup;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;
import pl.allegro.tech.hermes.management.domain.consistency.DcConsistencyService;
import pl.allegro.tech.hermes.management.domain.consistency.KafkaHermesConsistencyService;

@Component
@RolesAllowed(value={"admin"})
@Path(value="consistency")
public class ConsistencyEndpoint {
    private final DcConsistencyService dcConsistencyService;
    private final KafkaHermesConsistencyService kafkaHermesConsistencyService;

    public ConsistencyEndpoint(DcConsistencyService dcConsistencyService, KafkaHermesConsistencyService kafkaHermesConsistencyService) {
        this.dcConsistencyService = dcConsistencyService;
        this.kafkaHermesConsistencyService = kafkaHermesConsistencyService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/groups")
    public Response listInconsistentGroups(@QueryParam(value="groupNames") List<String> groupNames) {
        List<InconsistentGroup> inconsistentGroups = this.dcConsistencyService.listInconsistentGroups(new HashSet<String>(groupNames));
        return Response.ok().entity((Object)new GenericEntity<List<InconsistentGroup>>(inconsistentGroups){}).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/topics")
    public Response listInconsistentTopics() {
        return Response.ok((Object)new GenericEntity<Set<String>>(this.kafkaHermesConsistencyService.listInconsistentTopics()){}).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/topics")
    public Response removeTopicByName(@QueryParam(value="topicName") String topicName, @Context SecurityContext securityContext) {
        this.kafkaHermesConsistencyService.removeTopic(topicName, RequestUser.fromSecurityContext(securityContext));
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public Response listAllGroups() {
        Set<String> groupNames = this.dcConsistencyService.listAllGroupNames();
        return Response.ok().entity((Object)new GenericEntity<Set<String>>(groupNames){}).build();
    }
}

