/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.UnhealthySubscription;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSource;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;

@Path(value="unhealthy")
public class UnhealthyEndpoint {
    private final OwnerSources ownerSources;
    private final SubscriptionService subscriptionService;

    @Autowired
    public UnhealthyEndpoint(OwnerSources ownerSources, SubscriptionService subscriptionService) {
        this.ownerSources = ownerSources;
        this.subscriptionService = subscriptionService;
    }

    @GET
    @Produces(value={"application/json", "text/plain"})
    @Path(value="/")
    public Response listUnhealthy(@QueryParam(value="ownerSourceName") String ownerSourceName, @QueryParam(value="ownerId") String id, @DefaultValue(value="true") @QueryParam(value="respectMonitoringSeverity") boolean respectMonitoringSeverity, @QueryParam(value="subscriptionNames") List<String> subscriptionNames, @QueryParam(value="qualifiedTopicNames") List<String> qualifiedTopicNames) {
        List unhealthySubscriptions = this.areEmpty(ownerSourceName, id) ? this.subscriptionService.getAllUnhealthy(respectMonitoringSeverity, subscriptionNames, qualifiedTopicNames) : this.resolveOwnerId(ownerSourceName, id).map(ownerId -> this.subscriptionService.getUnhealthyForOwner((OwnerId)ownerId, respectMonitoringSeverity, subscriptionNames, qualifiedTopicNames)).orElseThrow(() -> new OwnerSource.OwnerNotFound(ownerSourceName, id));
        return Response.ok().entity((Object)new GenericEntity<List<UnhealthySubscription>>(unhealthySubscriptions){}).build();
    }

    private boolean areEmpty(String ownerSourceName, String id) {
        return ownerSourceName == null && id == null;
    }

    private Optional<OwnerId> resolveOwnerId(String ownerSourceName, String id) {
        return this.ownerSources.getByName(ownerSourceName).map(ownerSource -> new OwnerId(ownerSource.name(), id));
    }
}

