/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageAnySchemaVersionContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageHeaderSchemaIdContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageHeaderSchemaVersionContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageSchemaIdAwareContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageSchemaVersionTruncationContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.CompositeMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.DeserializationMetrics;
import pl.allegro.tech.hermes.common.message.wrapper.JsonMessageContentWrapper;
import pl.allegro.tech.hermes.management.config.MessageProperties;
import pl.allegro.tech.hermes.schema.SchemaRepository;

@Configuration
@EnableConfigurationProperties(value={MessageProperties.class})
public class MessageConfiguration {
    @Autowired
    MessageProperties messageProperties;
    @Autowired
    Clock clock;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    SchemaRepository schemaRepository;
    @Autowired
    MetricRegistry metricRegistry;

    @Bean
    CompositeMessageContentWrapper messageContentWrapper() {
        DeserializationMetrics metrics = new DeserializationMetrics(this.metricRegistry);
        AvroMessageContentWrapper avroWrapper = new AvroMessageContentWrapper(this.clock);
        JsonMessageContentWrapper jsonWrapper = this.jsonMessageContentWrapper();
        AvroMessageAnySchemaVersionContentWrapper anySchemaWrapper = new AvroMessageAnySchemaVersionContentWrapper(this.schemaRepository, () -> true, avroWrapper, metrics);
        AvroMessageHeaderSchemaVersionContentWrapper headerSchemaVersionWrapper = new AvroMessageHeaderSchemaVersionContentWrapper(this.schemaRepository, avroWrapper, metrics);
        AvroMessageHeaderSchemaIdContentWrapper headerSchemaIdWrapper = new AvroMessageHeaderSchemaIdContentWrapper(this.schemaRepository, avroWrapper, metrics, this.messageProperties.isSchemaIdHeaderEnabled());
        AvroMessageSchemaIdAwareContentWrapper schemaAwareWrapper = new AvroMessageSchemaIdAwareContentWrapper(this.schemaRepository, avroWrapper, metrics);
        AvroMessageSchemaVersionTruncationContentWrapper schemaVersionTruncationContentWrapper = new AvroMessageSchemaVersionTruncationContentWrapper(this.schemaRepository, avroWrapper, metrics, this.messageProperties.isSchemaVersionTruncationEnabled());
        return new CompositeMessageContentWrapper(jsonWrapper, avroWrapper, schemaAwareWrapper, headerSchemaVersionWrapper, headerSchemaIdWrapper, anySchemaWrapper, schemaVersionTruncationContentWrapper);
    }

    private JsonMessageContentWrapper jsonMessageContentWrapper() {
        return new JsonMessageContentWrapper(this.messageProperties.getContentRoot(), this.messageProperties.getMetadataContentRoot(), this.objectMapper);
    }
}

