/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.blacklist.commands;

import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class RemoveTopicFromBlacklistRepositoryCommand
extends RepositoryCommand<TopicBlacklistRepository> {
    private final String qualifiedTopicName;
    private boolean exists = false;

    public RemoveTopicFromBlacklistRepositoryCommand(String qualifiedTopicName) {
        this.qualifiedTopicName = qualifiedTopicName;
    }

    @Override
    public void backup(TopicBlacklistRepository repository) {
        this.exists = repository.isBlacklisted(this.qualifiedTopicName);
    }

    @Override
    public void execute(TopicBlacklistRepository repository) {
        repository.remove(this.qualifiedTopicName);
    }

    @Override
    public void rollback(TopicBlacklistRepository repository) {
        if (this.exists) {
            repository.add(this.qualifiedTopicName);
        }
    }

    @Override
    public Class<TopicBlacklistRepository> getRepositoryType() {
        return TopicBlacklistRepository.class;
    }

    public String toString() {
        return "RemoveTopicFromBlacklist(" + this.qualifiedTopicName + ")";
    }
}

