/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.migration.owner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.management.domain.group.GroupService;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;

@Component
public class SupportTeamToOwnerMigrator {
    private static final Logger logger = LoggerFactory.getLogger(SupportTeamToOwnerMigrator.class);
    private static final String MIGRATION_USER = "migration";
    private static final String OWNER_ALREADY_EXISTED_REASON = "owner already exists";
    private final GroupService groupService;
    private final TopicService topicService;
    private final SubscriptionService subscriptionService;

    @Autowired
    public SupportTeamToOwnerMigrator(GroupService groupService, TopicService topicService, SubscriptionService subscriptionService) {
        this.groupService = groupService;
        this.topicService = topicService;
        this.subscriptionService = subscriptionService;
    }

    public ExecutionStats execute(String sourceName, OwnerExistsStrategy strategy) {
        logger.info("Migrating support teams to owners...");
        EntityMigrationCounters topicCounters = new EntityMigrationCounters();
        EntityMigrationCounters subscriptionCounters = new EntityMigrationCounters();
        for (Group group : this.groupService.listGroups()) {
            for (Topic topic : this.topicService.listTopics(group.getGroupName())) {
                this.migrateTopic(topic, group, sourceName, strategy, topicCounters);
                for (Subscription subscription : this.subscriptionService.listSubscriptions(topic.getName())) {
                    this.migrateSubscription(subscription, sourceName, strategy, subscriptionCounters);
                }
            }
        }
        ExecutionStats stats = new ExecutionStats(topicCounters.toStats(), subscriptionCounters.toStats());
        logger.info("Done migrating support teams to owners: {}", (Object)stats);
        return stats;
    }

    private void migrateSubscription(Subscription subscription, String sourceName, OwnerExistsStrategy strategy, EntityMigrationCounters subscriptionCounters) {
        if (subscription.getOwner() == null || strategy == OwnerExistsStrategy.OVERRIDE) {
            this.migrateEntity(subscriptionCounters, "subscription " + subscription.getQualifiedName(), () -> this.subscriptionService.updateSubscription(subscription.getTopicName(), subscription.getName(), this.patchWithOwner(sourceName, subscription.getSupportTeam()), MIGRATION_USER));
        } else {
            subscriptionCounters.markSkipped(OWNER_ALREADY_EXISTED_REASON);
        }
    }

    private void migrateTopic(Topic topic, Group group, String sourceName, OwnerExistsStrategy strategy, EntityMigrationCounters topicCounters) {
        if (topic.getOwner() == null || strategy == OwnerExistsStrategy.OVERRIDE) {
            this.migrateEntity(topicCounters, "topic " + topic.getQualifiedName(), () -> this.topicService.updateTopic(topic.getName(), this.patchWithOwner(sourceName, group.getSupportTeam()), MIGRATION_USER));
        } else {
            topicCounters.markSkipped(OWNER_ALREADY_EXISTED_REASON);
        }
    }

    private void migrateEntity(EntityMigrationCounters topicCounters, String humanReadableEntityName, Runnable migration) {
        try {
            migration.run();
            topicCounters.markMigrated();
        }
        catch (Exception e) {
            logger.info("Failed to migrate {}, skipping", (Object)humanReadableEntityName, (Object)e);
            topicCounters.markSkipped(e.getClass().getTypeName());
        }
    }

    private PatchData patchWithOwner(String sourceName, String supportTeam) {
        return PatchData.patchData().set("owner", (Object)new OwnerId(sourceName, Strings.nullToEmpty((String)supportTeam))).build();
    }

    public static class EntityMigrationStats {
        private final int migrated;
        private final Map<String, Integer> skipped;

        @JsonCreator
        public EntityMigrationStats(@JsonProperty(value="migrated") int migrated, @JsonProperty(value="skipped") Map<String, Integer> skipped) {
            this.migrated = migrated;
            this.skipped = ImmutableMap.copyOf(skipped);
        }

        @JsonProperty(value="migrated")
        public int migrated() {
            return this.migrated;
        }

        @JsonProperty(value="skipped")
        public Map<String, Integer> skipped() {
            return this.skipped;
        }

        public String toString() {
            return "EntityMigrationStats{migrated=" + this.migrated + ", skipped=" + this.skipped + '}';
        }
    }

    public static class ExecutionStats {
        private final EntityMigrationStats topics;
        private final EntityMigrationStats subscriptions;

        @JsonCreator
        public ExecutionStats(@JsonProperty(value="topics") EntityMigrationStats topics, @JsonProperty(value="subscriptions") EntityMigrationStats subscriptions) {
            this.topics = topics;
            this.subscriptions = subscriptions;
        }

        @JsonProperty(value="topics")
        public EntityMigrationStats topics() {
            return this.topics;
        }

        @JsonProperty(value="subscriptions")
        public EntityMigrationStats subscriptions() {
            return this.subscriptions;
        }

        public String toString() {
            return "ExecutionStats{topics=" + this.topics + ", subscriptions=" + this.subscriptions + '}';
        }
    }

    private static class EntityMigrationCounters {
        private int migrated = 0;
        private Map<String, Integer> skipped = new HashMap<String, Integer>();

        private EntityMigrationCounters() {
        }

        void markMigrated() {
            ++this.migrated;
        }

        void markSkipped(String reason) {
            this.skipped.compute(reason, (key, old) -> (old != null ? old : 0) + 1);
        }

        EntityMigrationStats toStats() {
            return new EntityMigrationStats(this.migrated, this.skipped);
        }
    }

    public static enum OwnerExistsStrategy {
        OVERRIDE,
        SKIP;

    }
}

