/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.blacklist;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.blacklist.commands.AddTopicToBlacklistRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.blacklist.commands.RemoveTopicFromBlacklistRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;

@Component
public class TopicBlacklistService {
    private final TopicBlacklistRepository repository;
    private final MultiDatacenterRepositoryCommandExecutor multiDcExecutor;

    @Autowired
    public TopicBlacklistService(TopicBlacklistRepository repository, MultiDatacenterRepositoryCommandExecutor multiDcExecutor) {
        this.repository = repository;
        this.multiDcExecutor = multiDcExecutor;
    }

    public void blacklist(String qualifiedTopicName) {
        this.multiDcExecutor.execute(new AddTopicToBlacklistRepositoryCommand(qualifiedTopicName));
    }

    public void unblacklist(String qualifiedTopicName) {
        this.multiDcExecutor.execute(new RemoveTopicFromBlacklistRepositoryCommand(qualifiedTopicName));
    }

    public boolean isBlacklisted(String qualifiedTopicName) {
        return this.repository.isBlacklisted(qualifiedTopicName);
    }

    public List<String> list() {
        return this.repository.list();
    }
}

