/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.domain.CredentialsRepository;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.topic.preview.MessagePreviewRepository;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperCredentialsRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperGroupRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperMessagePreviewRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperOAuthProviderRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperTopicRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperWorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.config.storage.DefaultZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.config.storage.StorageClustersProperties;
import pl.allegro.tech.hermes.management.config.storage.ZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.infrastructure.blacklist.ZookeeperTopicBlacklistRepository;
import pl.allegro.tech.hermes.management.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.management.infrastructure.dc.DcNameSource;
import pl.allegro.tech.hermes.management.infrastructure.dc.DefaultDatacenterNameProvider;
import pl.allegro.tech.hermes.management.infrastructure.dc.EnvironmentVariableDatacenterNameProvider;
import pl.allegro.tech.hermes.management.infrastructure.metrics.SummedDistributedEphemeralCounter;
import pl.allegro.tech.hermes.management.infrastructure.metrics.SummedSharedCounter;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClientManager;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperRepositoryManager;

@Configuration
@EnableConfigurationProperties(value={StorageClustersProperties.class})
public class StorageConfiguration {
    @Autowired
    StorageClustersProperties storageClustersProperties;
    @Autowired
    ObjectMapper objectMapper;

    @Bean
    DatacenterNameProvider dcNameProvider() {
        if (this.storageClustersProperties.getDatacenterNameSource() == DcNameSource.ENV) {
            return new EnvironmentVariableDatacenterNameProvider(this.storageClustersProperties.getDatacenterNameSourceEnv());
        }
        return new DefaultDatacenterNameProvider();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    ZookeeperClientManager clientManager() {
        return new ZookeeperClientManager(this.storageClustersProperties, this.dcNameProvider());
    }

    @Bean
    ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory() {
        return new DefaultZookeeperGroupRepositoryFactory();
    }

    @Bean(initMethod="start")
    ZookeeperRepositoryManager repositoryManager(ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory) {
        return new ZookeeperRepositoryManager(this.clientManager(), this.dcNameProvider(), this.objectMapper, this.zookeeperPaths(), zookeeperGroupRepositoryFactory, this.storageClustersProperties.getAdminReaperInterval());
    }

    @Bean
    ZookeeperPaths zookeeperPaths() {
        return new ZookeeperPaths(this.storageClustersProperties.getPathPrefix());
    }

    @Bean
    MultiDatacenterRepositoryCommandExecutor multiDcRepositoryCommandExecutor(ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory) {
        return new MultiDatacenterRepositoryCommandExecutor(this.repositoryManager(zookeeperGroupRepositoryFactory), this.storageClustersProperties.isTransactional());
    }

    @Bean
    SummedSharedCounter summedSharedCounter(ZookeeperClientManager manager) {
        return new SummedSharedCounter(this.getCuratorClients(manager), this.storageClustersProperties.getSharedCountersExpiration(), this.storageClustersProperties.getRetrySleep(), this.storageClustersProperties.getRetryTimes());
    }

    @Bean
    SummedDistributedEphemeralCounter summedDistributedEphemeralCounter(ZookeeperClientManager manager) {
        return new SummedDistributedEphemeralCounter(this.getCuratorClients(manager));
    }

    @Bean
    GroupRepository groupRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperGroupRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    CredentialsRepository credentialsRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperCredentialsRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    TopicRepository topicRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperTopicRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths(), this.groupRepository());
    }

    @Bean
    SubscriptionRepository subscriptionRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperSubscriptionRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths(), this.topicRepository());
    }

    @Bean
    OAuthProviderRepository oAuthProviderRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperOAuthProviderRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    MessagePreviewRepository messagePreviewRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperMessagePreviewRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    TopicBlacklistRepository topicBlacklistRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperTopicBlacklistRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    WorkloadConstraintsRepository workloadConstraintsRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperWorkloadConstraintsRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @PostConstruct
    public void init() {
        this.ensureInitPathExists();
    }

    private void ensureInitPathExists() {
        ZookeeperClientManager clientManager = this.clientManager();
        for (ZookeeperClient client : clientManager.getClients()) {
            client.ensurePathExists(this.zookeeperPaths().groupsPath());
        }
    }

    private List<CuratorFramework> getCuratorClients(ZookeeperClientManager manager) {
        return manager.getClients().stream().map(ZookeeperClient::getCuratorFramework).collect(Collectors.toList());
    }
}

