/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.time;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeFormatter {
    private static final Logger logger = LoggerFactory.getLogger(TimeFormatter.class);
    private final PeriodFormatter hourFormatter;
    private final Clock clock;

    @Autowired
    public TimeFormatter(Clock clock) {
        this.clock = clock;
        this.hourFormatter = new PeriodFormatterBuilder().appendPrefix("-").appendHours().appendSuffix("h").toFormatter();
    }

    public Long parse(String formattedTime) {
        try {
            Period period = this.hourFormatter.parsePeriod(formattedTime);
            return LocalDateTime.now().minusHours(period.getHours()).atZone(this.clock.getZone()).toInstant().toEpochMilli();
        }
        catch (IllegalArgumentException e) {
            logger.info("Could not parse period. {}", (Object)e.getMessage());
            try {
                return LocalDateTime.parse(formattedTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(this.clock.getZone()).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException e2) {
                logger.info("Could not parse date. {}", (Object)e2.getMessage());
                throw new IllegalArgumentException("Could not parse given time. Available formats: period in hours (ex. \"-7h\") or ISO local date time");
            }
        }
    }
}

