/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.management.config.HealthProperties;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.DisabledIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.LaggingIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.MalfunctioningIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.ReceivingMalformedMessagesIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.TimingOutIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.UnreachableIndicator;

@Configuration
@EnableConfigurationProperties(value={HealthProperties.class})
public class HealthConfiguration {
    private static final DisabledIndicator DISABLED_INDICATOR = new DisabledIndicator();
    @Autowired
    private HealthProperties healthProperties;

    @Bean
    public SubscriptionHealthProblemIndicator laggingIndicator() {
        if (this.healthProperties.isLaggingIndicatorEnabled()) {
            return new LaggingIndicator(this.healthProperties.getMaxLagInSeconds());
        }
        return DISABLED_INDICATOR;
    }

    @Bean
    public SubscriptionHealthProblemIndicator unreachableIndicator() {
        if (this.healthProperties.isUnreachableIndicatorEnabled()) {
            return new UnreachableIndicator(this.healthProperties.getMaxOtherErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
        }
        return DISABLED_INDICATOR;
    }

    @Bean
    public SubscriptionHealthProblemIndicator timingOutIndicator() {
        if (this.healthProperties.isTimingOutIndicatorEnabled()) {
            return new TimingOutIndicator(this.healthProperties.getMaxTimeoutsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
        }
        return DISABLED_INDICATOR;
    }

    @Bean
    public SubscriptionHealthProblemIndicator malfunctioningIndicator() {
        if (this.healthProperties.isMalfunctioningIndicatorEnabled()) {
            return new MalfunctioningIndicator(this.healthProperties.getMax5xxErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
        }
        return DISABLED_INDICATOR;
    }

    @Bean
    public SubscriptionHealthProblemIndicator receivingMalformedMessagesIndicator() {
        if (this.healthProperties.isReceivingMalformedMessagesIndicatorEnabled()) {
            return new ReceivingMalformedMessagesIndicator(this.healthProperties.getMax4xxErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
        }
        return DISABLED_INDICATOR;
    }
}

