/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.springframework.stereotype.Component;

@Component
@Path(value="/roles")
@Api(value="/roles", description="Get user roles for given resource")
public class RolesEndpoint {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get general user roles", httpMethod="GET")
    public Collection<String> getRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Collections.emptyList());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}")
    @ApiOperation(value="Get topic user roles", httpMethod="GET")
    public Collection<String> getTopicRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Collections.singletonList("topicOwner"));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}/subscriptions/{subscriptionName}")
    @ApiOperation(value="Get subscription user roles", httpMethod="GET")
    public Collection<String> getSubscriptionRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Arrays.asList("topicOwner", "subscriptionOwner"));
    }

    private Collection<String> getRoles(ContainerRequestContext requestContext, Collection<String> additionalRoles) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        ArrayList<String> roles = new ArrayList<String>();
        this.ifUserInRoleDo(securityContext, "admin", roles::add);
        this.ifUserInRoleDo(securityContext, "any", roles::add);
        for (String role : additionalRoles) {
            this.ifUserInRoleDo(securityContext, role, roles::add);
        }
        return roles;
    }

    private void ifUserInRoleDo(SecurityContext securityContext, String role, Consumer<String> consumer) {
        if (securityContext.isUserInRole(role)) {
            consumer.accept(role);
        }
    }
}

