/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config.kafka;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.common.kafka.NamespaceKafkaNamesMapper;
import pl.allegro.tech.hermes.management.config.kafka.KafkaClustersProperties;
import pl.allegro.tech.hermes.management.config.kafka.KafkaNamesMappers;
import pl.allegro.tech.hermes.management.config.kafka.KafkaProperties;

public interface MultipleDcKafkaNamesMappersFactory {
    default public KafkaNamesMappers createDefaultKafkaNamesMapper(KafkaClustersProperties clustersProperties) {
        return this.createKafkaNamesMapper(clustersProperties, namespace -> new NamespaceKafkaNamesMapper(namespace));
    }

    default public KafkaNamesMappers createKafkaNamesMapper(KafkaClustersProperties clustersProperties, Function<String, KafkaNamesMapper> factoryFunction) {
        Map<String, KafkaNamesMapper> mappers = clustersProperties.getClusters().stream().filter(c -> c.getNamespace().isEmpty()).collect(Collectors.toMap(KafkaProperties::getQualifiedClusterName, kafkaProperties -> (KafkaNamesMapper)factoryFunction.apply(clustersProperties.getDefaultNamespace())));
        mappers.putAll(clustersProperties.getClusters().stream().filter(c -> !c.getNamespace().isEmpty()).collect(Collectors.toMap(KafkaProperties::getQualifiedClusterName, kafkaProperties -> (KafkaNamesMapper)factoryFunction.apply(kafkaProperties.getNamespace()))));
        return new KafkaNamesMappers(mappers);
    }
}

