/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.workload.constraints.command;

import pl.allegro.tech.hermes.api.Constraints;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class UpdateTopicConstraintsRepositoryCommand
extends RepositoryCommand<WorkloadConstraintsRepository> {
    private final TopicName topicName;
    private final Constraints constraints;
    private Constraints backup;

    public UpdateTopicConstraintsRepositoryCommand(TopicName topicName, Constraints constraints) {
        this.topicName = topicName;
        this.constraints = constraints;
    }

    @Override
    public void backup(WorkloadConstraintsRepository repository) {
        this.backup = (Constraints)repository.getConsumersWorkloadConstraints().getTopicConstraints().get(this.topicName);
    }

    @Override
    public void execute(WorkloadConstraintsRepository repository) {
        repository.updateConstraints(this.topicName, this.constraints);
    }

    @Override
    public void rollback(WorkloadConstraintsRepository repository) {
        if (this.backup != null) {
            repository.updateConstraints(this.topicName, this.backup);
        }
    }

    @Override
    public Class<WorkloadConstraintsRepository> getRepositoryType() {
        return WorkloadConstraintsRepository.class;
    }

    public String toString() {
        return String.format("UpdateTopicConstraints(%s)", this.topicName.qualifiedName());
    }
}

