/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic.commands;

import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class UpdateTopicRepositoryCommand
extends RepositoryCommand<TopicRepository> {
    private final Topic topic;
    private Topic backup;

    public UpdateTopicRepositoryCommand(Topic topic) {
        this.topic = topic;
    }

    @Override
    public void backup(TopicRepository repository) {
        this.backup = repository.getTopicDetails(this.topic.getName());
    }

    @Override
    public void execute(TopicRepository repository) {
        repository.updateTopic(this.topic);
    }

    @Override
    public void rollback(TopicRepository repository) {
        repository.updateTopic(this.backup);
    }

    @Override
    public Class<TopicRepository> getRepositoryType() {
        return TopicRepository.class;
    }

    public String toString() {
        return "UpdateTopic(" + this.topic.getQualifiedName() + ")";
    }
}

