/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.commands;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class RemoveSubscriptionRepositoryCommand
extends RepositoryCommand<SubscriptionRepository> {
    private final TopicName topicName;
    private final String subscriptionName;
    private Subscription backup;

    public RemoveSubscriptionRepositoryCommand(TopicName topicName, String subscriptionName) {
        this.topicName = topicName;
        this.subscriptionName = subscriptionName;
    }

    @Override
    public void backup(SubscriptionRepository repository) {
        this.backup = repository.getSubscriptionDetails(this.topicName, this.subscriptionName);
    }

    @Override
    public void execute(SubscriptionRepository repository) {
        repository.removeSubscription(this.topicName, this.subscriptionName);
    }

    @Override
    public void rollback(SubscriptionRepository repository) {
        repository.createSubscription(this.backup);
    }

    @Override
    public Class<SubscriptionRepository> getRepositoryType() {
        return SubscriptionRepository.class;
    }

    public String toString() {
        return "RemoveSubscription(" + new SubscriptionName(this.subscriptionName, this.topicName).getQualifiedName() + ")";
    }
}

