/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.management.domain.console.ConsoleService;

@Component
@Path(value="/")
@Api(value="/", description="Hermes console")
public class ConsoleEndpoint {
    private ConsoleService service;

    public ConsoleEndpoint(ConsoleService service) {
        this.service = service;
    }

    @GET
    @ApiOperation(value="Redirect to Hermes console", httpMethod="GET")
    public Response redirectToConsole() {
        return Response.status((Response.Status)Response.Status.FOUND).location(URI.create("/ui/index.html")).build();
    }

    @GET
    @Path(value="/console")
    @Produces(value={"application/javascript"})
    @ApiOperation(value="Hermes console configuration", httpMethod="GET")
    public String getConfiguration() {
        return this.service.getConfiguration();
    }
}

