/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.oauth;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Anonymizable;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.management.api.validator.ApiPreconditions;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.domain.oauth.commands.CreateOAuthProviderRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.oauth.commands.RemoveOAuthProviderRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.oauth.commands.UpdateOAuthProviderRepositoryCommand;

@Component
public class OAuthProviderService {
    private final OAuthProviderRepository repository;
    private final ApiPreconditions preconditions;
    private final Auditor auditor;
    private final MultiDatacenterRepositoryCommandExecutor multiDcExecutor;

    @Autowired
    public OAuthProviderService(OAuthProviderRepository repository, ApiPreconditions preconditions, Auditor auditor, MultiDatacenterRepositoryCommandExecutor multiDcExecutor) {
        this.repository = repository;
        this.preconditions = preconditions;
        this.auditor = auditor;
        this.multiDcExecutor = multiDcExecutor;
    }

    public List<String> listOAuthProviderNames() {
        return this.repository.listOAuthProviderNames();
    }

    public OAuthProvider getOAuthProviderDetails(String oAuthProviderName) {
        return this.repository.getOAuthProviderDetails(oAuthProviderName).anonymize();
    }

    public void createOAuthProvider(OAuthProvider oAuthProvider, String createdBy) {
        this.preconditions.checkConstraints(oAuthProvider);
        this.multiDcExecutor.execute(new CreateOAuthProviderRepositoryCommand(oAuthProvider));
        this.auditor.objectCreated(createdBy, (Anonymizable)oAuthProvider);
    }

    public void removeOAuthProvider(String oAuthProviderName, String removedBy) {
        this.multiDcExecutor.execute(new RemoveOAuthProviderRepositoryCommand(oAuthProviderName));
        this.auditor.objectRemoved(removedBy, OAuthProvider.class.getSimpleName(), oAuthProviderName);
    }

    public void updateOAuthProvider(String oAuthProviderName, PatchData patch, String updatedBy) {
        OAuthProvider retrieved = this.repository.getOAuthProviderDetails(oAuthProviderName);
        OAuthProvider updated = (OAuthProvider)Patch.apply((Object)retrieved, (PatchData)patch);
        this.preconditions.checkConstraints(updated);
        this.multiDcExecutor.execute(new UpdateOAuthProviderRepositoryCommand(updated));
        this.auditor.objectUpdated(updatedBy, (Anonymizable)retrieved, (Anonymizable)updated);
    }
}

