/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.workload.constraints.command;

import pl.allegro.tech.hermes.api.Constraints;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class DeleteTopicConstraintsRepositoryCommand
extends RepositoryCommand<WorkloadConstraintsRepository> {
    private final TopicName topicName;
    private Constraints backup;

    public DeleteTopicConstraintsRepositoryCommand(TopicName topicName) {
        this.topicName = topicName;
    }

    @Override
    public void backup(WorkloadConstraintsRepository repository) {
        this.backup = (Constraints)repository.getConsumersWorkloadConstraints().getTopicConstraints().get(this.topicName);
    }

    @Override
    public void execute(WorkloadConstraintsRepository repository) {
        repository.deleteConstraints(this.topicName);
    }

    @Override
    public void rollback(WorkloadConstraintsRepository repository) {
        if (this.backup != null) {
            repository.createConstraints(this.topicName, this.backup);
        }
    }

    @Override
    public Class<WorkloadConstraintsRepository> getRepositoryType() {
        return WorkloadConstraintsRepository.class;
    }

    public String toString() {
        return String.format("DeleteTopicConstraints(%s)", this.topicName.qualifiedName());
    }
}

