/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.blacklist;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperBasedRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.management.domain.blacklist.NotUnblacklistedException;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;

public class ZookeeperTopicBlacklistRepository
extends ZookeeperBasedRepository
implements TopicBlacklistRepository {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperTopicBlacklistRepository.class);

    public ZookeeperTopicBlacklistRepository(CuratorFramework zookeeper, ObjectMapper mapper, ZookeeperPaths paths) {
        super(zookeeper, mapper, paths);
    }

    @Override
    public void add(String qualifiedTopicName) {
        logger.info("Adding topic {} to Blacklist", (Object)qualifiedTopicName);
        this.ensurePathExists(this.paths.blacklistedTopicPath(qualifiedTopicName));
    }

    @Override
    public void remove(String qualifiedTopicName) {
        logger.info("Removing topic {} from Blacklist", (Object)qualifiedTopicName);
        try {
            super.remove(this.paths.blacklistedTopicPath(qualifiedTopicName));
        }
        catch (Exception e) {
            logger.warn("Removing topic {} from Blacklist caused an exception", (Object)qualifiedTopicName, (Object)e);
            throw new NotUnblacklistedException(qualifiedTopicName, e);
        }
    }

    @Override
    public boolean isBlacklisted(String qualifiedTopicName) {
        return this.pathExists(this.paths.blacklistedTopicPath(qualifiedTopicName));
    }

    @Override
    public List<String> list() {
        return this.childrenOf(this.paths.topicsBlacklistPath());
    }
}

