/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.management.domain.oauth.OAuthProviderService;

@Component
@Path(value="/oauth/providers")
@Api(value="/oauth/providers", description="Operations on OAuth providers")
public class OAuthProvidersEndpoint {
    private final OAuthProviderService service;

    @Autowired
    public OAuthProvidersEndpoint(OAuthProviderService service) {
        this.service = service;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List OAuth providers", httpMethod="GET")
    public List<String> list() {
        return this.service.listOAuthProviderNames();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oAuthProviderName}")
    @ApiOperation(value="OAuth provider details", httpMethod="GET")
    public OAuthProvider get(@PathParam(value="oAuthProviderName") String oAuthProviderName) {
        return this.service.getOAuthProviderDetails(oAuthProviderName);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Create OAuth provider", httpMethod="POST")
    public Response create(OAuthProvider oAuthProvider, @Context SecurityContext securityContext) {
        this.service.createOAuthProvider(oAuthProvider, securityContext.getUserPrincipal().getName());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="/{oAuthProviderName}")
    @ApiOperation(value="Update OAuth provider", httpMethod="PUT")
    public Response update(@PathParam(value="oAuthProviderName") String oAuthProviderName, PatchData patch, @Context SecurityContext securityContext) {
        this.service.updateOAuthProvider(oAuthProviderName, patch, securityContext.getUserPrincipal().getName());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="/{oAuthProviderName}")
    @ApiOperation(value="Remove OAuth provider", httpMethod="DELETE")
    public Response remove(@PathParam(value="oAuthProviderName") String oAuthProviderName, @Context SecurityContext securityContext) {
        this.service.removeOAuthProvider(oAuthProviderName, securityContext.getUserPrincipal().getName());
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

