/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain;

import pl.allegro.tech.hermes.api.Anonymizable;
import pl.allegro.tech.hermes.api.PatchData;

public interface Auditor {
    default public void beforeObjectCreation(String username, Object createdObject) {
    }

    default public void beforeObjectCreation(String username, Anonymizable createdObject) {
        this.beforeObjectCreation(username, (Object)createdObject.anonymize());
    }

    default public void beforeObjectRemoval(String username, String removedObjectType, String removedObjectName) {
    }

    default public void beforeObjectUpdate(String username, String objectClassName, Object objectName, PatchData patchData) {
    }

    default public void objectCreated(String username, Object createdObject) {
    }

    default public void objectCreated(String username, Anonymizable createdObject) {
        this.objectCreated(username, (Object)createdObject.anonymize());
    }

    default public void objectRemoved(String username, String removedObjectType, String removedObjectName) {
    }

    default public void objectUpdated(String username, Object oldObject, Object newObject) {
    }

    default public void objectUpdated(String username, Anonymizable oldObject, Anonymizable newObject) {
        this.objectUpdated(username, (Object)oldObject.anonymize(), (Object)newObject.anonymize());
    }

    public static Auditor noOpAuditor() {
        return new NoOpAuditor();
    }

    public static class NoOpAuditor
    implements Auditor {
        private NoOpAuditor() {
        }
    }
}

