/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.commands;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class UpdateSubscriptionRepositoryCommand
extends RepositoryCommand<SubscriptionRepository> {
    private final Subscription subscription;
    private Subscription backup;

    public UpdateSubscriptionRepositoryCommand(Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public void backup(SubscriptionRepository repository) {
        this.backup = repository.getSubscriptionDetails(this.subscription.getTopicName(), this.subscription.getName());
    }

    @Override
    public void execute(SubscriptionRepository repository) {
        repository.updateSubscription(this.subscription);
    }

    @Override
    public void rollback(SubscriptionRepository repository) {
        repository.updateSubscription(this.backup);
    }

    @Override
    public Class<SubscriptionRepository> getRepositoryType() {
        return SubscriptionRepository.class;
    }

    public String toString() {
        return "UpdateSubscription(" + this.subscription.getQualifiedName() + ")";
    }
}

