/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.crowd;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.management.config.CrowdProperties;
import pl.allegro.tech.hermes.management.infrastructure.crowd.CrowdClient;

public class CachedCrowdClient
implements CrowdClient {
    private final LoadingCache<String, List<String>> cache;

    public CachedCrowdClient(final CrowdClient crowdClient, CrowdProperties crowdProperties) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(crowdProperties.getCacheDurationSeconds().longValue(), TimeUnit.SECONDS).maximumSize(crowdProperties.getCacheSize().longValue()).build((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String searchString) throws Exception {
                return crowdClient.getGroups(searchString);
            }
        });
    }

    @Override
    public List<String> getGroups(String searchString) {
        try {
            return (List)this.cache.get((Object)searchString);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new CrowdClient.CouldNotLoadCrowdGroupsException(e);
        }
    }
}

