/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.DatacenterReadiness;
import pl.allegro.tech.hermes.api.Readiness;
import pl.allegro.tech.hermes.management.domain.readiness.ReadinessService;

@Path(value="readiness/datacenters")
@Component
public class ReadinessEndpoint {
    private final ReadinessService readinessService;

    public ReadinessEndpoint(ReadinessService readinessService) {
        this.readinessService = readinessService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{datacenter}")
    public Response setReadiness(@PathParam(value="datacenter") String datacenter, Readiness readiness) {
        this.readinessService.setReady(new DatacenterReadiness(datacenter, readiness.isReady()));
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<DatacenterReadiness> getReadiness() {
        return this.readinessService.getDatacentersReadinesses();
    }
}

