/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.group;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.group.GroupNotExistsException;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.infrastructure.MalformedDataException;
import pl.allegro.tech.hermes.management.api.auth.CreatorRights;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.domain.group.GroupValidator;
import pl.allegro.tech.hermes.management.domain.group.commands.CreateGroupRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.group.commands.RemoveGroupRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.group.commands.UpdateGroupRepositoryCommand;

@Component
public class GroupService {
    private static final Logger logger = LoggerFactory.getLogger(GroupService.class);
    private final GroupRepository groupRepository;
    private final Auditor auditor;
    private final MultiDatacenterRepositoryCommandExecutor multiDcExecutor;
    private final GroupValidator validator;

    @Autowired
    public GroupService(GroupRepository groupRepository, Auditor auditor, MultiDatacenterRepositoryCommandExecutor multiDcExecutor, GroupValidator validator) {
        this.groupRepository = groupRepository;
        this.auditor = auditor;
        this.multiDcExecutor = multiDcExecutor;
        this.validator = validator;
    }

    public List<Group> listGroups() {
        return this.groupRepository.listGroups();
    }

    public List<String> listGroupNames() {
        return this.groupRepository.listGroupNames();
    }

    public Group getGroupDetails(String groupName) {
        return this.groupRepository.getGroupDetails(groupName);
    }

    public void createGroup(Group group, String createdBy, CreatorRights<Group> creatorRights) {
        this.validator.checkCreation(group, creatorRights);
        this.multiDcExecutor.execute(new CreateGroupRepositoryCommand(group));
        this.auditor.objectCreated(createdBy, group);
    }

    public void removeGroup(String groupName, String removedBy) {
        this.multiDcExecutor.execute(new RemoveGroupRepositoryCommand(groupName));
        this.auditor.objectRemoved(removedBy, Group.class.getSimpleName(), groupName);
    }

    public void checkGroupExists(String groupName) {
        if (!this.groupRepository.groupExists(groupName)) {
            throw new GroupNotExistsException(groupName);
        }
    }

    public void updateGroup(String groupName, PatchData patch, String modifiedBy) {
        try {
            Group retrieved = this.groupRepository.getGroupDetails(groupName);
            Group modified = (Group)Patch.apply((Object)retrieved, (PatchData)patch);
            this.multiDcExecutor.execute(new UpdateGroupRepositoryCommand(modified));
            this.groupRepository.updateGroup(modified);
            this.auditor.objectUpdated(modifiedBy, retrieved, modified);
        }
        catch (MalformedDataException exception) {
            logger.warn("Problem with reading details of group {}.", (Object)groupName);
            throw exception;
        }
    }

    public List<Group> queryGroup(Query<Group> query) {
        return query.filter(this.listGroups()).collect(Collectors.toList());
    }
}

