/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.dc;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.ExceptionWrapper;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;

public class MultiDatacenterRepositoryCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MultiDatacenterRepositoryCommandExecutor.class);
    private final RepositoryManager repositoryManager;
    private final boolean rollbackEnabled;

    public MultiDatacenterRepositoryCommandExecutor(RepositoryManager repositoryManager, boolean rollbackEnabled) {
        this.repositoryManager = repositoryManager;
        this.rollbackEnabled = rollbackEnabled;
    }

    public <T> void execute(RepositoryCommand<T> command) {
        if (this.rollbackEnabled) {
            this.backup(command);
        }
        List<DatacenterBoundRepositoryHolder<T>> repoHolders = this.repositoryManager.getRepositories(command.getRepositoryType());
        ArrayList<DatacenterBoundRepositoryHolder<T>> executedRepoHolders = new ArrayList<DatacenterBoundRepositoryHolder<T>>();
        for (DatacenterBoundRepositoryHolder<T> repoHolder : repoHolders) {
            try {
                executedRepoHolders.add(repoHolder);
                command.execute(repoHolder);
            }
            catch (Exception e) {
                logger.warn("Execute failed with an error", (Throwable)e);
                if (this.rollbackEnabled) {
                    this.rollback(executedRepoHolders, command);
                }
                throw ExceptionWrapper.wrapInInternalProcessingExceptionIfNeeded(e, command.toString(), repoHolder.getDatacenterName());
            }
        }
    }

    private <T> void rollback(List<DatacenterBoundRepositoryHolder<T>> repoHolders, RepositoryCommand<T> command) {
        for (DatacenterBoundRepositoryHolder<T> repoHolder : repoHolders) {
            try {
                command.rollback(repoHolder);
            }
            catch (Exception e) {
                logger.error("Rollback procedure failed for command {} on DC {}", new Object[]{command, repoHolder.getDatacenterName(), e});
            }
        }
    }

    private <T> void backup(RepositoryCommand<T> command) {
        DatacenterBoundRepositoryHolder<T> repoHolder = this.repositoryManager.getLocalRepository(command.getRepositoryType());
        try {
            logger.debug("Creating backup for command: {}", command);
            command.backup(repoHolder);
        }
        catch (Exception e) {
            throw new InternalProcessingException("Backup procedure for command '" + command + "' failed on DC '" + repoHolder.getDatacenterName() + "'.", (Throwable)e);
        }
    }
}

