/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic;

import java.util.Objects;
import javax.ws.rs.core.SecurityContext;

public class TopicManipulatorUser {
    private final String username;
    private final boolean isAdmin;

    public TopicManipulatorUser(String username, boolean isAdmin) {
        this.username = username;
        this.isAdmin = isAdmin;
    }

    public static TopicManipulatorUser fromSecurityContext(SecurityContext securityContext) {
        String username = securityContext.getUserPrincipal().getName();
        boolean isAdmin = securityContext.isUserInRole("admin");
        return new TopicManipulatorUser(username, isAdmin);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicManipulatorUser topicManipulatorUser = (TopicManipulatorUser)o;
        return this.isAdmin == topicManipulatorUser.isAdmin && Objects.equals(this.username, topicManipulatorUser.username);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.isAdmin);
    }
}

