<!doctype html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Hermes Console</title>

        <link href="components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" media="screen">
        <link href="components/angularjs-toaster/toaster.css" rel="stylesheet" media="screen">
        <link href="components/font-awesome/css/font-awesome.min.css" rel="stylesheet" media="screen">
        <link href="components/json-formatter/dist/json-formatter.min.css.css" rel="stylesheet" media="screen">
        <link href="components/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" media="screen">
        <link href="css/main.css" rel="stylesheet" media="screen">

        <script src="components/jquery/dist/jquery.min.js"></script>
        <script src="components/angular/angular.js"></script>
        <script src="components/angular-deferred-bootstrap/angular-deferred-bootstrap.min.js"></script>
        <script src="components/angular-ui-router/release/angular-ui-router.min.js"></script>
        <script src="components/angular-resource/angular-resource.js"></script>
        <script src="components/angular-sanitize/angular-sanitize.js"></script>
        <script src="components/angular-animate/angular-animate.min.js"></script>
        <script src="components/angular-bootstrap/ui-bootstrap-tpls.min.js"></script>
        <script src="components/lodash/dist/lodash.min.js"></script>
        <script src="components/angularjs-toaster/toaster.js"></script>
        <script src="components/json-formatter/dist/json-formatter.min.js.js"></script>
        <script src="components/hello/dist/hello.min.js"></script>
        <script src="components/moment/min/moment.min.js"></script>
        <script src="components/eonasdan-bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js"></script>
        <script src="components/utf8/utf8.js"></script>

        <script src="/console"></script>

        <script src="js/directives/endpoint.js"></script>
        <script src="js/directives/hoverDelay.js"></script>
        <script src="js/directives/emptyToNull.js"></script>
        <script src="js/directives/bindHtml.js"></script>
        <script src="js/console/Filters.js"></script>
        <script src="js/console/Discovery.js"></script>
        <script src="js/console/Home.js"></script>
        <script src="js/console/PasswordService.js"></script>
        <script src="js/console/owner/OwnerRepository.js"></script>
        <script src="js/console/owner/OwnerSelector.js"></script>
        <script src="js/console/owner/OwnerName.js"></script>
        <script src="js/console/Modals.js"></script>
        <script src="js/console/MetricStoreUrlResolver.js"></script>
        <script src="js/console/subscription/SubscriptionRepository.js"></script>
        <script src="js/console/subscription/SubscriptionHealth.js"></script>
        <script src="js/console/subscription/SubscriptionMetrics.js"></script>
        <script src="js/console/subscription/SubscriptionFactory.js"></script>
        <script src="js/console/subscription/SubscriptionController.js"></script>
        <script src="js/console/filters/FiltersEditor.js"></script>
        <script src="js/console/filters/HttpHeaderFiltersEditor.js"></script>
        <script src="js/console/filters/FiltersRepository.js"></script>
        <script src="js/console/filters/FiltersDebugger.js"></script>
        <script src="js/console/constraints/ConstraintsRepository.js"></script>
        <script src="js/console/constraints/ConstraintsController.js"></script>
        <script src="js/console/readiness/ReadinessController.js"></script>
        <script src="js/console/readiness/ReadinessRepository.js"></script>
        <script src="js/console/diagnostics/DiagnosticsRepository.js"></script>
        <script src="js/console/diagnostics/DiagnosticsController.js"></script>
        <script src="js/console/consistency/ConsistencyRepository.js"></script>
        <script src="js/console/consistency/ConsistencyController.js"></script>
        <script src="js/console/topic/TopicRepository.js"></script>
        <script src="js/console/topic/TopicFactory.js"></script>
        <script src="js/console/topic/TopicMetrics.js"></script>
        <script src="js/console/topic/TopicController.js"></script>
        <script src="js/console/Groups.js"></script>
        <script src="js/console/MessagePreview.js"></script>
        <script src="js/console/Auth.js"></script>
        <script src="js/console/Search.js"></script>
        <script src="js/console/Stats.js"></script>
        <script src="js/console/Visibility.js"></script>
        <script src="js/console/Mode.js"></script>
        <script src="js/app.js"></script>
        <script src="js/bootstrap.js"></script>
        <script type="text/javascript" src="components/ace-builds/src-min-noconflict/ace.js"></script>
        <script type="text/javascript" src="components/angular-ui-ace/ui-ace.js"></script>
        <script type="text/javascript" src="components/ace-builds/src-min-noconflict/ext-language_tools.js"></script>

    </head>
    <body>
        <nav class="navbar navbar-default" role="navigation">
            <div class="container-fluid">
                <div class="navbar-header">
                    <a class="navbar-brand console-title" href="#/">
                        <span><img class="logo-mini" src="img/hermes-logo.png" alt="Hermes"/></span>
                        &nbsp;&nbsp; {{console.title}}
                    </a>
                </div>
                <auth-pane ng-show="enabled"></auth-pane>
            </div>
        </nav>
        <div ng-if="readOnly" class="container alert alert-danger">
            <h4 class="alert-heading">Running in read only mode</h4>
            If you need to make any modifications, please contact the Hermes administrators.
        </div>

        <toaster-container toaster-options="{'time-out': {'toast-error': 0, 'toast-warning': 0, 'toast-success': 5000, 'toast-info': 5000}, 'close-button': {'toast-error': true, 'toast-warning': true}}"></toaster-container>
        <div ui-view class="container"></div>

        <footer ng-bind-html="console.footer"></footer>
    </body>
</html>
