/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.InconsistentGroup;
import pl.allegro.tech.hermes.management.domain.consistency.ConsistencyService;

@Component
@RolesAllowed(value={"admin"})
@Path(value="consistency")
public class ConsistencyEndpoint {
    private final ConsistencyService consistencyService;

    public ConsistencyEndpoint(ConsistencyService consistencyService) {
        this.consistencyService = consistencyService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/groups")
    public Response listInconsistentGroups(@QueryParam(value="groupNames") List<String> groupNames) {
        List<InconsistentGroup> inconsistentGroups = this.consistencyService.listInconsistentGroups(new HashSet<String>(groupNames));
        return Response.ok().entity((Object)new GenericEntity<List<InconsistentGroup>>(inconsistentGroups){}).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public Response listAllGroups() {
        Set<String> groupNames = this.consistencyService.listAllGroupNames();
        return Response.ok().entity((Object)new GenericEntity<Set<String>>(groupNames){}).build();
    }
}

