/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic.schema;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.RawSchema;
import pl.allegro.tech.hermes.api.RawSchemaWithMetadata;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaRemovalDisabledException;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidatorProvider;
import pl.allegro.tech.hermes.schema.RawSchemaClient;
import pl.allegro.tech.hermes.schema.SchemaVersion;

@Component
public class SchemaService {
    private final RawSchemaClient rawSchemaClient;
    private final SchemaValidatorProvider validatorProvider;
    private final TopicProperties topicProperties;

    @Autowired
    public SchemaService(RawSchemaClient rawSchemaClient, SchemaValidatorProvider validatorProvider, TopicProperties topicProperties) {
        this.rawSchemaClient = rawSchemaClient;
        this.validatorProvider = validatorProvider;
        this.topicProperties = topicProperties;
    }

    public Optional<RawSchema> getSchema(String qualifiedTopicName) {
        return this.rawSchemaClient.getLatestRawSchemaWithMetadata(TopicName.fromQualifiedName((String)qualifiedTopicName)).map(RawSchemaWithMetadata::getSchema);
    }

    public void registerSchema(Topic topic, String schema) {
        boolean validate = ContentType.AVRO.equals((Object)topic.getContentType());
        this.registerSchema(topic, schema, validate);
    }

    public void registerSchema(Topic topic, String schema, boolean validate) {
        if (validate) {
            SchemaValidator validator = this.validatorProvider.provide(topic.getContentType());
            validator.check(schema);
        }
        this.rawSchemaClient.registerSchema(topic.getName(), RawSchema.valueOf((String)schema));
    }

    public Optional<RawSchema> getSchema(String qualifiedTopicName, SchemaVersion version) {
        return this.rawSchemaClient.getRawSchemaWithMetadata(TopicName.fromQualifiedName((String)qualifiedTopicName), version).map(RawSchemaWithMetadata::getSchema);
    }

    public void deleteAllSchemaVersions(String qualifiedTopicName) {
        if (!this.topicProperties.isRemoveSchema()) {
            throw new SchemaRemovalDisabledException();
        }
        this.rawSchemaClient.deleteAllSchemaVersions(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    public void validateSchema(Topic topic, String schema) {
        if (ContentType.AVRO.equals((Object)topic.getContentType())) {
            SchemaValidator validator = this.validatorProvider.provide(ContentType.AVRO);
            validator.check(schema);
        }
        this.rawSchemaClient.validateSchema(topic.getName(), RawSchema.valueOf((String)schema));
    }
}

