/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.auth;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.management.api.auth.SecurityProvider;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;

public class HermesSecurityAwareRequestUser
implements RequestUser {
    private final String username;
    private final boolean isAdmin;
    private final SecurityProvider.OwnershipResolver ownershipResolver;

    public HermesSecurityAwareRequestUser(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        this.username = securityContext.getUserPrincipal().getName();
        this.isAdmin = securityContext.isUserInRole("admin");
        this.ownershipResolver = (SecurityProvider.OwnershipResolver)requestContext.getProperty("ownership-resolver");
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public boolean isOwner(OwnerId ownerId) {
        return this.ownershipResolver.isUserAnOwner(ownerId);
    }
}

