/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.validator;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.constraints.AdminPermitted;

@Component
public class ApiPreconditions {
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public <T> void checkConstraints(T object, boolean skipAdminPermitted) {
        Class[] groups = this.groupsToValidate(skipAdminPermitted);
        Set violations = this.validator.validate(object, groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    private Class<?>[] groupsToValidate(boolean skipAdminPermitted) {
        if (skipAdminPermitted) {
            return new Class[]{Default.class};
        }
        return new Class[]{Default.class, AdminPermitted.class};
    }
}

