/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

@Component
public class SubscriptionOwnerCache {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionOwnerCache.class);
    private final SubscriptionRepository subscriptionRepository;
    private final ScheduledExecutorService scheduledExecutorService;
    private Multimap<OwnerId, SubscriptionName> cache = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());

    public SubscriptionOwnerCache(SubscriptionRepository subscriptionRepository, @Value(value="${subscriptionOwnerCache.refreshRateInSeconds}") int refreshRateInSeconds) {
        this.subscriptionRepository = subscriptionRepository;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("subscription-owner-cache-%d").build());
        this.scheduledExecutorService.scheduleAtFixedRate(this::refillCache, 0L, refreshRateInSeconds, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    Collection<SubscriptionName> get(OwnerId ownerId) {
        return this.cache.get((Object)ownerId);
    }

    Collection<SubscriptionName> getAll() {
        return this.cache.values();
    }

    void onRemovedSubscription(String subscriptionName, TopicName topicName) {
        this.cache.entries().removeIf(entry -> ((SubscriptionName)entry.getValue()).equals((Object)new SubscriptionName(subscriptionName, topicName)));
    }

    void onCreatedSubscription(Subscription subscription) {
        this.cache.put((Object)subscription.getOwner(), (Object)subscription.getQualifiedName());
    }

    void onUpdatedSubscription(Subscription oldSubscription, Subscription newSubscription) {
        this.cache.remove((Object)oldSubscription.getOwner(), (Object)oldSubscription.getQualifiedName());
        this.cache.put((Object)newSubscription.getOwner(), (Object)newSubscription.getQualifiedName());
    }

    private void refillCache() {
        try {
            logger.info("Starting filling SubscriptionOwnerCache");
            long start = System.currentTimeMillis();
            ArrayListMultimap cache = ArrayListMultimap.create();
            this.subscriptionRepository.listAllSubscriptions().forEach(arg_0 -> SubscriptionOwnerCache.lambda$refillCache$1((Multimap)cache, arg_0));
            this.cache = Multimaps.synchronizedMultimap((Multimap)cache);
            long end = System.currentTimeMillis();
            logger.info("SubscriptionOwnerCache filled. Took {}ms", (Object)(end - start));
        }
        catch (Exception e) {
            logger.error("Error while filling SubscriptionOwnerCache", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$refillCache$1(Multimap cache, Subscription subscription) {
        cache.put((Object)subscription.getOwner(), (Object)subscription.getQualifiedName());
    }
}

