/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.validator;

import com.damnhandy.uri.template.UriTemplate;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.management.domain.subscription.validator.EndpointAddressValidator;
import pl.allegro.tech.hermes.management.domain.subscription.validator.EndpointValidationException;

public class EndpointAddressFormatValidator
implements EndpointAddressValidator {
    private final Set<String> availableProtocol = new HashSet<String>();

    public EndpointAddressFormatValidator(List<String> additionalEndpointProtocols) {
        this.availableProtocol.addAll(additionalEndpointProtocols);
        this.availableProtocol.add("http");
        this.availableProtocol.add("https");
        this.availableProtocol.add("jms");
        this.availableProtocol.add("googlepubsub");
    }

    @Override
    public void check(EndpointAddress address) {
        this.checkIfProtocolIsValid(address);
        this.checkIfUriIsValid(address);
    }

    private void checkIfProtocolIsValid(EndpointAddress address) {
        if (!this.availableProtocol.contains(address.getProtocol())) {
            throw new EndpointValidationException("Endpoint address has invalid format");
        }
    }

    private void checkIfUriIsValid(EndpointAddress address) {
        UriTemplate template = UriTemplate.fromTemplate((String)address.getRawEndpoint());
        if (this.isInvalidHost(template)) {
            throw new EndpointValidationException("Endpoint contains invalid chars in host name. Underscore is one of them.");
        }
    }

    private boolean isInvalidHost(UriTemplate template) {
        Map uriKeysWithEmptyValues = Arrays.asList(template.getVariables()).stream().collect(Collectors.toMap(Function.identity(), v -> "empty"));
        return URI.create(template.expand(uriKeysWithEmptyValues)).getHost() == null;
    }
}

