/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.ConsumerGroup;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.kafka.ConsumerGroupId;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.management.domain.message.RetransmissionService;
import pl.allegro.tech.hermes.management.domain.subscription.consumergroup.ConsumerGroupManager;
import pl.allegro.tech.hermes.management.domain.topic.BrokerTopicManagement;
import pl.allegro.tech.hermes.management.domain.topic.SingleMessageReader;
import pl.allegro.tech.hermes.management.infrastructure.kafka.MovingSubscriptionOffsetsValidationException;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.ConsumerGroupsDescriber;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.LogEndOffsetChecker;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.OffsetsAvailableChecker;

public class BrokersClusterService {
    private static final Logger logger = LoggerFactory.getLogger(BrokersClusterService.class);
    private final String datacenter;
    private final String clusterName;
    private final SingleMessageReader singleMessageReader;
    private final RetransmissionService retransmissionService;
    private final BrokerTopicManagement brokerTopicManagement;
    private final KafkaNamesMapper kafkaNamesMapper;
    private final OffsetsAvailableChecker offsetsAvailableChecker;
    private final ConsumerGroupsDescriber consumerGroupsDescriber;
    private final AdminClient adminClient;
    private final ConsumerGroupManager consumerGroupManager;

    public BrokersClusterService(String datacenter, String clusterName, SingleMessageReader singleMessageReader, RetransmissionService retransmissionService, BrokerTopicManagement brokerTopicManagement, KafkaNamesMapper kafkaNamesMapper, OffsetsAvailableChecker offsetsAvailableChecker, LogEndOffsetChecker logEndOffsetChecker, AdminClient adminClient, ConsumerGroupManager consumerGroupManager) {
        this.datacenter = datacenter;
        this.clusterName = clusterName;
        this.singleMessageReader = singleMessageReader;
        this.retransmissionService = retransmissionService;
        this.brokerTopicManagement = brokerTopicManagement;
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.offsetsAvailableChecker = offsetsAvailableChecker;
        this.consumerGroupsDescriber = new ConsumerGroupsDescriber(kafkaNamesMapper, adminClient, logEndOffsetChecker, clusterName);
        this.adminClient = adminClient;
        this.consumerGroupManager = consumerGroupManager;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public void manageTopic(Consumer<BrokerTopicManagement> manageFunction) {
        manageFunction.accept(this.brokerTopicManagement);
    }

    public String readMessageFromPrimary(Topic topic, Integer partition, Long offset) {
        return this.singleMessageReader.readMessageAsJson(topic, this.kafkaNamesMapper.toKafkaTopics(topic).getPrimary(), partition, offset);
    }

    public void indicateOffsetChange(Topic topic, String subscriptionName, List<PartitionOffset> partitionOffsets) {
        this.retransmissionService.indicateOffsetChange(topic, subscriptionName, this.clusterName, partitionOffsets);
    }

    public List<PartitionOffset> fetchTopicOffsetsAt(Topic topic, Long timestamp) {
        return this.retransmissionService.fetchTopicOffsetsAt(topic, timestamp);
    }

    public boolean areOffsetsAvailableOnAllKafkaTopics(Topic topic) {
        return this.kafkaNamesMapper.toKafkaTopics(topic).allMatch(this.offsetsAvailableChecker::areOffsetsAvailable);
    }

    public boolean topicExists(Topic topic) {
        return this.brokerTopicManagement.topicExists(topic);
    }

    public List<String> listTopicsFromCluster() {
        try {
            return new ArrayList<String>((Collection)this.adminClient.listTopics().names().get());
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Failed to list topics names", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void removeTopicByName(String topicName) {
        this.adminClient.deleteTopics(Collections.singletonList(topicName));
    }

    public boolean areOffsetsMoved(Topic topic, String subscriptionName) {
        return this.retransmissionService.areOffsetsMoved(topic, subscriptionName, this.clusterName);
    }

    public boolean allSubscriptionsHaveConsumersAssigned(Topic topic, List<Subscription> subscriptions) {
        List<String> consumerGroupsForSubscriptions = subscriptions.stream().map(sub -> this.kafkaNamesMapper.toConsumerGroupId(sub.getQualifiedName()).asString()).collect(Collectors.toList());
        try {
            int requiredTotalNumberOfAssignments = this.numberOfPartitionsForTopic(topic) * subscriptions.size();
            return this.numberOfAssignmentsForConsumersGroups(consumerGroupsForSubscriptions) == requiredTotalNumberOfAssignments;
        }
        catch (Exception e) {
            logger.error("Failed to check assignments for topic " + topic.getQualifiedName() + " subscriptions", (Throwable)e);
            return false;
        }
    }

    public void createConsumerGroup(Topic topic, Subscription subscription) {
        this.consumerGroupManager.createConsumerGroup(topic, subscription);
    }

    public void deleteConsumerGroup(SubscriptionName subscriptionName) {
        this.consumerGroupManager.deleteConsumerGroup(subscriptionName);
    }

    public Optional<ConsumerGroup> describeConsumerGroup(Topic topic, String subscriptionName) {
        return this.consumerGroupsDescriber.describeConsumerGroup(topic, subscriptionName);
    }

    public void moveOffsets(SubscriptionName subscription, List<PartitionOffset> offsets) {
        ConsumerGroupId consumerGroupId = this.kafkaNamesMapper.toConsumerGroupId(subscription);
        Map<TopicPartition, OffsetAndMetadata> offsetAndMetadata = this.buildOffsetsMetadata(offsets);
        this.adminClient.alterConsumerGroupOffsets(consumerGroupId.asString(), offsetAndMetadata).all();
        logger.info("Successfully moved offsets for subscription {} and consumer group {} to {}", new Object[]{subscription.getQualifiedName(), this.kafkaNamesMapper.toConsumerGroupId(subscription), offsetAndMetadata.toString()});
    }

    private int numberOfAssignmentsForConsumersGroups(List<String> consumerGroupsIds) throws ExecutionException, InterruptedException {
        Collection consumerGroupsDescriptions = ((Map)this.adminClient.describeConsumerGroups(consumerGroupsIds).all().get()).values();
        Stream memberDescriptions = consumerGroupsDescriptions.stream().flatMap(desc -> desc.members().stream());
        return memberDescriptions.flatMap(memberDescription -> memberDescription.assignment().topicPartitions().stream()).collect(Collectors.toList()).size();
    }

    public void validateIfOffsetsCanBeMovedByConsumers(Topic topic, SubscriptionName subscription) {
        this.describeConsumerGroup(topic, subscription.getName()).ifPresentOrElse(group -> {
            if (!group.isStable()) {
                String s = String.format("Consumer group %s for subscription %s is not stable.", group.getGroupId(), subscription.getQualifiedName());
                throw new MovingSubscriptionOffsetsValidationException(s);
            }
        }, () -> {
            String s = String.format("No consumer group for subscription %s exists.", subscription.getQualifiedName());
            throw new MovingSubscriptionOffsetsValidationException(s);
        });
    }

    public void validateIfOffsetsCanBeMoved(Topic topic, SubscriptionName subscription) {
        this.describeConsumerGroup(topic, subscription.getName()).ifPresentOrElse(group -> {
            if (!group.isEmpty()) {
                String s = String.format("Consumer group %s for subscription %s has still active members.", group.getGroupId(), subscription.getQualifiedName());
                throw new MovingSubscriptionOffsetsValidationException(s);
            }
        }, () -> {
            String s = String.format("No consumer group for subscription %s exists.", subscription.getQualifiedName());
            throw new MovingSubscriptionOffsetsValidationException(s);
        });
    }

    private int numberOfPartitionsForTopic(Topic topic) throws ExecutionException, InterruptedException {
        List kafkaTopicsNames = this.kafkaNamesMapper.toKafkaTopics(topic).stream().map(kafkaTopic -> kafkaTopic.name().asString()).collect(Collectors.toList());
        return ((Map)this.adminClient.describeTopics(kafkaTopicsNames).all().get()).values().stream().map(v -> v.partitions().size()).reduce(0, Integer::sum);
    }

    private Set<TopicPartition> getTopicPartitions(KafkaConsumer<byte[], byte[]> consumer, String kafkaTopicName) {
        return consumer.partitionsFor(kafkaTopicName).stream().map(info -> new TopicPartition(info.topic(), info.partition())).collect(Collectors.toSet());
    }

    private Map<TopicPartition, OffsetAndMetadata> buildOffsetsMetadata(List<PartitionOffset> offsets) {
        return offsets.stream().map(offset -> ImmutablePair.of((Object)new TopicPartition(offset.getTopic().asString(), offset.getPartition()), (Object)new OffsetAndMetadata(offset.getOffset()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }
}

