/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ErrorCode;
import pl.allegro.tech.hermes.management.domain.ManagementException;
import pl.allegro.tech.hermes.management.domain.MetricsDashboardUrl;
import pl.allegro.tech.hermes.management.domain.MetricsDashboardUrlService;

@Component
@Path(value="/dashboards")
public class MetricsDashboardUrlEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(MetricsDashboardUrlEndpoint.class);
    private final Optional<MetricsDashboardUrlService> metricsDashboardUrlService;

    MetricsDashboardUrlEndpoint(Optional<MetricsDashboardUrlService> metricsDashboardUrlService) {
        if (metricsDashboardUrlService.isEmpty()) {
            logger.info("Dashboards url bean is absent");
        }
        this.metricsDashboardUrlService = metricsDashboardUrlService;
    }

    @GET
    @Path(value="/topics/{topic}")
    @Produces(value={"application/json"})
    public Response fetchUrlForTopic(@PathParam(value="topic") String topic) {
        return this.metricsDashboardUrlService.map(service -> Response.ok((Object)new MetricsDashboardUrl(service.getUrlForTopic(topic))).build()).orElseThrow(MetricsDashboardUrlAbsentException::new);
    }

    @GET
    @Path(value="/topics/{topic}/subscriptions/{subscription}")
    @Produces(value={"application/json"})
    public Response fetchUrlForSubscription(@PathParam(value="topic") String topic, @PathParam(value="subscription") String subscription) {
        return this.metricsDashboardUrlService.map(service -> Response.ok((Object)new MetricsDashboardUrl(service.getUrlForSubscription(topic, subscription))).build()).orElseThrow(MetricsDashboardUrlAbsentException::new);
    }

    private static class MetricsDashboardUrlAbsentException
    extends ManagementException {
        MetricsDashboardUrlAbsentException() {
            super("Dashboard url implementation is absent");
        }

        @Override
        public ErrorCode getCode() {
            return ErrorCode.IMPLEMENTATION_ABSENT;
        }
    }
}

