/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringSubscriptionMetricsProvider;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringTopicMetricsProvider;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;

public class PrometheusMetricsProvider
implements MonitoringSubscriptionMetricsProvider,
MonitoringTopicMetricsProvider {
    private static final String SUBSCRIPTION_DELIVERED = "subscription_delivered_total";
    private static final String SUBSCRIPTION_TIMEOUTS = "subscription_timeouts_total";
    private static final String SUBSCRIPTION_THROUGHPUT = "subscription_throughput_bytes_total";
    private static final String SUBSCRIPTION_OTHER_ERRORS = "subscription_other_errors_total";
    private static final String SUBSCRIPTION_BATCHES = "subscription_batches_total";
    private static final String SUBSCRIPTION_STATUS_CODES = "subscription_http_status_codes_total";
    private static final String SUBSCRIPTION_RETRIES = "subscription_retries_total";
    private static final String TOPIC_RATE = "topic_requests_total";
    private static final String TOPIC_DELIVERY_RATE = "subscription_delivered_total";
    private static final String TOPIC_THROUGHPUT_RATE = "topic_throughput_bytes_total";
    private final String consumersMetricsPrefix;
    private final String frontendMetricsPrefix;
    private final String additionalFilters;
    private final PrometheusClient prometheusClient;

    public PrometheusMetricsProvider(PrometheusClient prometheusClient, String consumersMetricsPrefix, String frontendMetricsPrefix, String additionalFilters) {
        this.prometheusClient = prometheusClient;
        this.consumersMetricsPrefix = consumersMetricsPrefix.isEmpty() ? "" : consumersMetricsPrefix + "_";
        this.frontendMetricsPrefix = frontendMetricsPrefix.isEmpty() ? "" : frontendMetricsPrefix + "_";
        this.additionalFilters = additionalFilters;
    }

    @Override
    public MonitoringSubscriptionMetricsProvider.MonitoringSubscriptionMetrics subscriptionMetrics(SubscriptionName subscriptionName) {
        String subscriptionDeliveredQuery = PrometheusClient.forSubscription(this.consumerMetricName("subscription_delivered_total"), subscriptionName, this.additionalFilters);
        String subscriptionTimeoutsQuery = PrometheusClient.forSubscription(this.consumerMetricName(SUBSCRIPTION_TIMEOUTS), subscriptionName, this.additionalFilters);
        String subscriptionThroughputQuery = PrometheusClient.forSubscription(this.consumerMetricName(SUBSCRIPTION_THROUGHPUT), subscriptionName, this.additionalFilters);
        String subscriptionOtherErrorsQuery = PrometheusClient.forSubscription(this.consumerMetricName(SUBSCRIPTION_OTHER_ERRORS), subscriptionName, this.additionalFilters);
        String subscriptionBatchesQuery = PrometheusClient.forSubscription(this.consumerMetricName(SUBSCRIPTION_BATCHES), subscriptionName, this.additionalFilters);
        String subscriptionRetriesQuery = PrometheusClient.forSubscription(this.consumerMetricName(SUBSCRIPTION_RETRIES), subscriptionName, this.additionalFilters);
        String subscription2xx = PrometheusClient.forSubscriptionStatusCode(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES), subscriptionName, "2.*", this.additionalFilters);
        String subscription4xx = PrometheusClient.forSubscriptionStatusCode(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES), subscriptionName, "4.*", this.additionalFilters);
        String subscription5xx = PrometheusClient.forSubscriptionStatusCode(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES), subscriptionName, "5.*", this.additionalFilters);
        MonitoringMetricsContainer prometheusMetricsContainer = this.prometheusClient.readMetrics(subscriptionDeliveredQuery, subscriptionTimeoutsQuery, subscriptionRetriesQuery, subscriptionThroughputQuery, subscriptionOtherErrorsQuery, subscriptionBatchesQuery, subscription2xx, subscription4xx, subscription5xx);
        return MonitoringSubscriptionMetricsProvider.metricsBuilder().withRate(prometheusMetricsContainer.metricValue(subscriptionDeliveredQuery)).withTimeouts(prometheusMetricsContainer.metricValue(subscriptionTimeoutsQuery)).withThroughput(prometheusMetricsContainer.metricValue(subscriptionThroughputQuery)).withOtherErrors(prometheusMetricsContainer.metricValue(subscriptionOtherErrorsQuery)).withMetricPathBatchRate(prometheusMetricsContainer.metricValue(subscriptionBatchesQuery)).withCodes2xx(prometheusMetricsContainer.metricValue(subscription2xx)).withCode4xx(prometheusMetricsContainer.metricValue(subscription4xx)).withCode5xx(prometheusMetricsContainer.metricValue(subscription5xx)).withRetries(prometheusMetricsContainer.metricValue(subscriptionRetriesQuery)).build();
    }

    @Override
    public MonitoringTopicMetricsProvider.MonitoringTopicMetrics topicMetrics(TopicName topicName) {
        String topicRateQuery = PrometheusClient.forTopic(this.frontendMetricName(TOPIC_RATE), topicName, this.additionalFilters);
        String topicDeliveryRateQuery = PrometheusClient.forTopic(this.consumerMetricName("subscription_delivered_total"), topicName, this.additionalFilters);
        String topicThroughputQuery = PrometheusClient.forTopic(this.frontendMetricName(TOPIC_THROUGHPUT_RATE), topicName, this.additionalFilters);
        MonitoringMetricsContainer prometheusMetricsContainer = this.prometheusClient.readMetrics(topicRateQuery, topicDeliveryRateQuery, topicThroughputQuery);
        return MonitoringTopicMetricsProvider.metricsBuilder().withRate(prometheusMetricsContainer.metricValue(topicRateQuery)).withDeliveryRate(prometheusMetricsContainer.metricValue(topicDeliveryRateQuery)).withThroughput(prometheusMetricsContainer.metricValue(topicThroughputQuery)).build();
    }

    private String consumerMetricName(String name) {
        return this.consumersMetricsPrefix + name;
    }

    private String frontendMetricName(String name) {
        return this.frontendMetricsPrefix + name;
    }
}

