/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.retransmit;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import pl.allegro.tech.hermes.api.OfflineRetransmissionFromTopicRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionFromViewRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionTask;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionRepository;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionValidationException;

public class OfflineRetransmissionService {
    private final OfflineRetransmissionRepository offlineRetransmissionRepository;
    private final TopicRepository topicRepository;

    public OfflineRetransmissionService(OfflineRetransmissionRepository offlineRetransmissionRepository, TopicRepository topicRepository) {
        this.offlineRetransmissionRepository = offlineRetransmissionRepository;
        this.topicRepository = topicRepository;
    }

    public void validateTopicRequest(OfflineRetransmissionFromTopicRequest request) {
        TopicName sourceTopicName = TopicName.fromQualifiedName((String)request.getSourceTopic());
        TopicName targetTopicName = TopicName.fromQualifiedName((String)request.getTargetTopic());
        this.ensureSourceTopicExists(sourceTopicName);
        this.ensureTargetTopicExists(targetTopicName);
        this.ensureTopicIsNotStoredOffline(targetTopicName);
    }

    public void validateViewRequest(OfflineRetransmissionFromViewRequest request) {
        TopicName targetTopicName = TopicName.fromQualifiedName((String)request.getTargetTopic());
        this.ensureTargetTopicExists(targetTopicName);
        this.ensureTopicIsNotStoredOffline(targetTopicName);
    }

    public OfflineRetransmissionTask createTopicTask(OfflineRetransmissionFromTopicRequest request) {
        OfflineRetransmissionTask task = new OfflineRetransmissionTask(OfflineRetransmissionRequest.RetransmissionType.TOPIC, UUID.randomUUID().toString(), null, request.getSourceTopic(), request.getTargetTopic(), request.getStartTimestamp(), request.getEndTimestamp(), Instant.now());
        this.offlineRetransmissionRepository.saveTask(task);
        return task;
    }

    public OfflineRetransmissionTask createViewTask(OfflineRetransmissionFromViewRequest request) {
        OfflineRetransmissionTask task = new OfflineRetransmissionTask(OfflineRetransmissionRequest.RetransmissionType.VIEW, UUID.randomUUID().toString(), request.getSourceViewPath(), null, request.getTargetTopic(), null, null, Instant.now());
        this.offlineRetransmissionRepository.saveTask(task);
        return task;
    }

    public List<OfflineRetransmissionTask> getAllTasks() {
        return this.offlineRetransmissionRepository.getAllTasks();
    }

    public void deleteTask(String taskId) {
        try {
            this.offlineRetransmissionRepository.deleteTask(taskId);
        }
        catch (InternalProcessingException ex) {
            if (ex.getCause() instanceof OfflineRetransmissionValidationException) {
                throw (OfflineRetransmissionValidationException)((Object)ex.getCause());
            }
            throw ex;
        }
    }

    private void ensureSourceTopicExists(TopicName sourceTopicName) {
        if (!this.topicRepository.topicExists(sourceTopicName)) {
            throw new OfflineRetransmissionValidationException("Source topic does not exist");
        }
    }

    private void ensureTargetTopicExists(TopicName targetTopicName) {
        if (!this.topicRepository.topicExists(targetTopicName)) {
            throw new OfflineRetransmissionValidationException("Target topic does not exist");
        }
    }

    private void ensureTopicIsNotStoredOffline(TopicName targetTopicName) {
        Topic targetTopic = this.topicRepository.getTopicDetails(targetTopicName);
        if (targetTopic.getOfflineStorage().isEnabled()) {
            throw new OfflineRetransmissionValidationException("Target topic must not be stored offline");
        }
    }
}

