/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OfflineRetransmissionFromTopicRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionFromViewRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionTask;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.api.auth.ManagementRights;
import pl.allegro.tech.hermes.management.domain.PermissionDeniedException;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionService;

@Component
@Path(value="offline-retransmission/tasks")
@Api(value="offline-retransmission/tasks", description="Offline retransmission operations")
public class OfflineRetransmissionEndpoint {
    private final OfflineRetransmissionService retransmissionService;
    private final RetransmissionPermissions permissions;
    private final OfflineRetransmissionAuditor auditor;
    private final Logger logger = LoggerFactory.getLogger(OfflineRetransmissionEndpoint.class);

    public OfflineRetransmissionEndpoint(OfflineRetransmissionService retransmissionService, TopicRepository topicRepository, ManagementRights managementRights) {
        this.retransmissionService = retransmissionService;
        this.permissions = new RetransmissionPermissions(topicRepository, managementRights);
        this.auditor = new OfflineRetransmissionAuditor();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRetransmissionTask(@Valid OfflineRetransmissionRequest request, @Context ContainerRequestContext requestContext) {
        this.logger.info("Offline retransmission request: {}", (Object)request);
        if (request.getType() == OfflineRetransmissionRequest.RetransmissionType.TOPIC) {
            this.createRetransmissionFromTopicTask(request, requestContext);
        } else {
            this.createRetransmissionFromViewTask(request, requestContext);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void createRetransmissionFromViewTask(OfflineRetransmissionRequest request, ContainerRequestContext requestContext) {
        OfflineRetransmissionFromViewRequest viewRequest = (OfflineRetransmissionFromViewRequest)request;
        this.retransmissionService.validateViewRequest(viewRequest);
        this.permissions.ensurePermissions(viewRequest, requestContext);
        OfflineRetransmissionTask task = this.retransmissionService.createViewTask(viewRequest);
        this.auditor.auditRetransmissionCreation(request, requestContext, task);
    }

    private void createRetransmissionFromTopicTask(OfflineRetransmissionRequest request, ContainerRequestContext requestContext) {
        OfflineRetransmissionFromTopicRequest topicRequest = (OfflineRetransmissionFromTopicRequest)request;
        this.retransmissionService.validateTopicRequest(topicRequest);
        this.permissions.ensurePermissions(topicRequest, requestContext);
        OfflineRetransmissionTask task = this.retransmissionService.createTopicTask(topicRequest);
        this.auditor.auditRetransmissionCreation(request, requestContext, task);
    }

    @GET
    @Produces(value={"application/json"})
    public List<OfflineRetransmissionTask> getAllRetransmissionTasks() {
        return this.retransmissionService.getAllTasks();
    }

    @DELETE
    @Path(value="/{taskId}")
    public Response deleteRetransmissionTask(@PathParam(value="taskId") String taskId) {
        this.retransmissionService.deleteTask(taskId);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private static class RetransmissionPermissions {
        private final Logger logger = LoggerFactory.getLogger(RetransmissionPermissions.class);
        private final TopicRepository topicRepository;
        private final ManagementRights managementRights;

        private RetransmissionPermissions(TopicRepository topicRepository, ManagementRights managementRights) {
            this.topicRepository = topicRepository;
            this.managementRights = managementRights;
        }

        private void ensurePermissions(OfflineRetransmissionFromTopicRequest request, ContainerRequestContext requestContext) {
            boolean hasPermissions;
            boolean bl = hasPermissions = this.validateTopicPermissions(request.getSourceTopic(), requestContext) && this.validateTopicPermissions(request.getTargetTopic(), requestContext);
            if (!hasPermissions) {
                this.logger.info("User {} has no permissions to make offline retransmission {}", (Object)requestContext.getSecurityContext().getUserPrincipal(), (Object)request);
                throw new PermissionDeniedException("User needs permissions to source and target topics.");
            }
        }

        private void ensurePermissions(OfflineRetransmissionFromViewRequest request, ContainerRequestContext requestContext) {
            Topic targetTopic = this.topicRepository.getTopicDetails(TopicName.fromQualifiedName((String)request.getTargetTopic()));
            boolean hasPermissions = this.managementRights.isUserAllowedToManageTopic(targetTopic, requestContext);
            if (!hasPermissions) {
                this.logger.info("User {} has no permissions to make offline retransmission {}", (Object)requestContext.getSecurityContext().getUserPrincipal(), (Object)request);
                throw new PermissionDeniedException("User needs permissions to target topic.");
            }
        }

        private boolean validateTopicPermissions(String sourceTopic, ContainerRequestContext requestContext) {
            return this.managementRights.isUserAllowedToManageTopic(this.topicRepository.getTopicDetails(TopicName.fromQualifiedName((String)sourceTopic)), requestContext);
        }
    }

    private static class OfflineRetransmissionAuditor {
        private static final Logger logger = LoggerFactory.getLogger(OfflineRetransmissionAuditor.class);

        private OfflineRetransmissionAuditor() {
        }

        public void auditRetransmissionCreation(OfflineRetransmissionRequest request, ContainerRequestContext requestContext, OfflineRetransmissionTask task) {
            String username = this.extractUsername(requestContext);
            logger.info("User {} created offline retransmission task: {}, taskId: {}", new Object[]{username, request, task.getTaskId()});
        }

        private String extractUsername(ContainerRequestContext requestContext) {
            return requestContext.getSecurityContext().getUserPrincipal().getName();
        }
    }
}

