/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.api.MetricDecimalValue;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusResponse;

public class RestTemplatePrometheusClient
implements PrometheusClient {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplatePrometheusClient.class);
    private final URI prometheusUri;
    private final RestTemplate restTemplate;
    private final ExecutorService executorService;
    private final Duration fetchingTimeout;
    private final MeterRegistry meterRegistry;

    public RestTemplatePrometheusClient(RestTemplate restTemplate, URI prometheusUri, ExecutorService executorService, Duration fetchingTimeoutMillis, MeterRegistry meterRegistry) {
        this.restTemplate = restTemplate;
        this.prometheusUri = prometheusUri;
        this.executorService = executorService;
        this.fetchingTimeout = fetchingTimeoutMillis;
        this.meterRegistry = meterRegistry;
    }

    @Override
    public MonitoringMetricsContainer readMetrics(List<String> queries) {
        return this.fetchInParallelFromPrometheus(queries);
    }

    private MonitoringMetricsContainer fetchInParallelFromPrometheus(List<String> queries) {
        CompletableFuture<Map<String, MetricDecimalValue>> aggregatedFuture = this.getAggregatedCompletableFuture(queries);
        try {
            Map<String, MetricDecimalValue> metrics = aggregatedFuture.get(this.fetchingTimeout.toMillis(), TimeUnit.MILLISECONDS);
            return MonitoringMetricsContainer.initialized(metrics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Prometheus fetching thread was interrupted...", (Throwable)e);
            return MonitoringMetricsContainer.unavailable();
        }
        catch (Exception ex) {
            logger.warn("Unexpected exception during fetching metrics from prometheus...", (Throwable)ex);
            return MonitoringMetricsContainer.unavailable();
        }
    }

    private CompletableFuture<Map<String, MetricDecimalValue>> getAggregatedCompletableFuture(List<String> queries) {
        List<CompletableFuture> futures = queries.stream().map(this::readSingleMetric).toList();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    private CompletableFuture<Pair<String, MetricDecimalValue>> readSingleMetric(String query) {
        return CompletableFuture.supplyAsync(() -> this.queryPrometheus(query), this.executorService);
    }

    private Pair<String, MetricDecimalValue> queryPrometheus(String query) {
        try {
            URI queryUri = URI.create(this.prometheusUri.toString() + "/api/v1/query?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
            PrometheusResponse response = (PrometheusResponse)this.restTemplate.exchange(queryUri, HttpMethod.GET, HttpEntity.EMPTY, PrometheusResponse.class).getBody();
            Preconditions.checkNotNull((Object)response, (Object)"Prometheus response is null");
            Preconditions.checkState((boolean)response.isSuccess(), (Object)"Prometheus response does not contain valid data");
            MetricDecimalValue result = this.parseResponse(response);
            this.meterRegistry.counter("read-metric-from-prometheus.success", new String[0]).increment();
            return Pair.of((Object)query, (Object)result);
        }
        catch (HttpStatusCodeException ex) {
            logger.warn("Unable to read from Prometheus. Query: {}, Status code: {}. Response body: {}", new Object[]{query, ex.getStatusCode(), ex.getResponseBodyAsString(), ex});
            return Pair.of((Object)query, (Object)MetricDecimalValue.unavailable());
        }
        catch (Exception ex) {
            logger.warn("Unable to read from Prometheus. Query: {}", (Object)query, (Object)ex);
            this.meterRegistry.counter("read-metric-from-prometheus.error", new String[0]).increment();
            return Pair.of((Object)query, (Object)MetricDecimalValue.unavailable());
        }
    }

    private MetricDecimalValue parseResponse(PrometheusResponse response) {
        return response.data().results().stream().findFirst().flatMap(PrometheusResponse.VectorResult::getValue).map(value -> MetricDecimalValue.of((String)value.toString())).orElse(MetricDecimalValue.defaultValue());
    }
}

