/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
@Path(value="/roles")
@Api(value="/roles", description="Get user roles for given resource")
public class RolesEndpoint {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get general user roles", httpMethod="GET")
    public Collection<String> getRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Collections.emptyList());
    }

    private Collection<String> getRoles(ContainerRequestContext requestContext, Collection<String> additionalRoles) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        ArrayList<String> roles = new ArrayList<String>();
        this.ifUserInRoleDo(securityContext, "admin", roles::add);
        this.ifUserInRoleDo(securityContext, "any", roles::add);
        for (String role : additionalRoles) {
            this.ifUserInRoleDo(securityContext, role, roles::add);
        }
        return roles;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}")
    @ApiOperation(value="Get topic user roles", httpMethod="GET")
    public Collection<String> getTopicRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Collections.singletonList("topicOwner"));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}/subscriptions/{subscriptionName}")
    @ApiOperation(value="Get subscription user roles", httpMethod="GET")
    public Collection<String> getSubscriptionRoles(ContainerRequestContext requestContext) {
        return this.getRoles(requestContext, Arrays.asList("topicOwner", "subscriptionOwner"));
    }

    private void ifUserInRoleDo(SecurityContext securityContext, String role, Consumer<String> consumer) {
        if (securityContext.isUserInRole(role)) {
            consumer.accept(role);
        }
    }
}

