/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Controller;
import pl.allegro.tech.hermes.tracker.management.TrackingUrlProvider;

@Controller
@Path(value="/tracking-urls")
@Api(value="/tracking-urls", description="Tracking urls for topics and subscriptions")
public class TrackingUrlsEndpoint {
    private final Optional<TrackingUrlProvider> trackingUrlProvider;

    public TrackingUrlsEndpoint(Optional<TrackingUrlProvider> trackingUrlProvider) {
        this.trackingUrlProvider = trackingUrlProvider;
    }

    @GET
    @Path(value="/topics/{topic}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"any"})
    @ApiOperation(value="Tracking urls for given topic", response=List.class, httpMethod="GET")
    public Response getTopicTrackingUrls(@PathParam(value="topic") String topic) {
        return this.trackingUrlProvider.map(provider -> Response.ok((Object)provider.getTrackingUrlsForTopic(topic))).orElse(Response.ok(List.of())).build();
    }

    @GET
    @Path(value="/topics/{topic}/subscriptions/{subscription}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"any"})
    @ApiOperation(value="Tracking urls for given subscription", response=List.class, httpMethod="GET")
    public Response getSubscriptionTrackingUrls(@PathParam(value="topic") String topic, @PathParam(value="subscription") String subscription) {
        return this.trackingUrlProvider.map(provider -> Response.ok((Object)provider.getTrackingUrlsForSubscription(topic, subscription))).orElse(Response.ok(List.of())).build();
    }
}

